package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * 应用信息表
 * @TableName ocp_tenant_base
 */
@Data
@Accessors(chain = true)
@TableName("ocp_tenant_base")
@ApiModel("应用信息表1")
public class OcpTenantBase implements Serializable {
    /**
     * 应用ID
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    private String objId;

    /**
     * 应用名称
     */
    @ApiModelProperty("应用名称")
    private String tenantName;

    /**
     * 应用代码
     */
    @ApiModelProperty("应用代码")
    private String tenantCode;

    /**
     * 应用分类代码
     */
    @ApiModelProperty("应用分类代码")
    private String tenantGroupCode;

    /**
     * 应用ip
     */
    @ApiModelProperty("应用ip")
    private String tenantIp;

    /**
     * 应用url
     */
    @ApiModelProperty("应用url")
    private String tenantUrl;

    /**
     * 所属专业
     */
    @ApiModelProperty("所属专业")
    private String professionalKind;

    /**
     * 创建者用户ID
     */
    @ApiModelProperty("创建者用户ID")
    private String tenantUserId;

    /**
     * 排序
     */
    @ApiModelProperty("排序")
    private Integer tenantOrderNo;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Timestamp tenantCtime;

    /**
     * 最后更新时间
     */
    @ApiModelProperty("最后更新时间")
    private Timestamp tenantMtime;

    /**
     * 部署名称
     */
    @ApiModelProperty("部署名称")
    private String deploymentName;

    /**
     * 描述
     */
    @ApiModelProperty("描述")
    private String tenantDescription;

    /**
     * 应用状态0:设计态；1:运行态
     */
    @ApiModelProperty("应用状态0:设计态；1:运行态")
    private Short tenantState;
    /**
     * 推广类型0:统建；1:自建
     */
    @ApiModelProperty("推广类型0:统建；1:自建")
    private long tenantPromotion;
    /**
     * 建设单位
     */
    @ApiModelProperty("建设单位")
    private String tenantUnit;

    /**
     * 所属公司编码
     */
    @ApiModelProperty("所属公司编码")
    private String ownerCompanyCode;

    /**
     * 所属公司名称
     */
    @ApiModelProperty("所属公司名称")
    private String ownerCompanyName;

    /**
     * 是否删除0:否;1:是
     */
    @ApiModelProperty("是否删除0:否;1:是")
    private Short isDelete;

    /**
     * 所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区
     */
    @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
    private Short tenantZone;

    /**
     * 所属层级 1:应用层;2:平台层;3:网络层;4:感知层;
     */
    @ApiModelProperty("所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
    private Short tenantLayer;

    /**
     * 应用版本（当前版本）
     */
    @ApiModelProperty("应用版本（当前版本）")
    private String tenantVersion;

    private static final long serialVersionUID = 1L;

    /**
     * 应用ID
     */
    public String getObjId() {
        return objId;
    }

    /**
     * 应用ID
     */
    public void setObjId(String objId) {
        this.objId = objId;
    }

    /**
     * 应用名称
     */
    public String getTenantName() {
        return tenantName;
    }

    /**
     * 应用名称
     */
    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    /**
     * 应用代码
     */
    public String getTenantCode() {
        return tenantCode;
    }

    /**
     * 应用代码
     */
    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    /**
     * 应用分类代码
     */
    public String getTenantGroupCode() {
        return tenantGroupCode;
    }

    /**
     * 应用分类代码
     */
    public void setTenantGroupCode(String tenantGroupCode) {
        this.tenantGroupCode = tenantGroupCode;
    }

    /**
     * 应用ip
     */
    public String getTenantIp() {
        return tenantIp;
    }

    /**
     * 应用ip
     */
    public void setTenantIp(String tenantIp) {
        this.tenantIp = tenantIp;
    }

    /**
     * 应用url
     */
    public String getTenantUrl() {
        return tenantUrl;
    }

    /**
     * 应用url
     */
    public void setTenantUrl(String tenantUrl) {
        this.tenantUrl = tenantUrl;
    }

    /**
     * 所属专业
     */
    public String getProfessionalKind() {
        return professionalKind;
    }

    /**
     * 所属专业
     */
    public void setProfessionalKind(String professionalKind) {
        this.professionalKind = professionalKind;
    }

    /**
     * 创建者用户ID
     */
    public String getTenantUserId() {
        return tenantUserId;
    }

    /**
     * 创建者用户ID
     */
    public void setTenantUserId(String tenantUserId) {
        this.tenantUserId = tenantUserId;
    }

    /**
     * 排序
     */
    public Integer getTenantOrderNo() {
        return tenantOrderNo;
    }

    /**
     * 排序
     */
    public void setTenantOrderNo(Integer tenantOrderNo) {
        this.tenantOrderNo = tenantOrderNo;
    }

    /**
     * 创建时间
     */
    public Date getTenantCtime() {
        return tenantCtime;
    }

    /**
     * 创建时间
     */
    public void setTenantCtime(Timestamp tenantCtime) {
        this.tenantCtime = tenantCtime;
    }

    /**
     * 最后更新时间
     */
    public Date getTenantMtime() {
        return tenantMtime;
    }

    /**
     * 最后更新时间
     */
    public void setTenantMtime(Timestamp tenantMtime) {
        this.tenantMtime = tenantMtime;
    }

    /**
     * 部署名称
     */
    public String getDeploymentName() {
        return deploymentName;
    }

    /**
     * 部署名称
     */
    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    /**
     * 描述
     */
    public String getTenantDescription() {
        return tenantDescription;
    }

    /**
     * 描述
     */
    public void setTenantDescription(String tenantDescription) {
        this.tenantDescription = tenantDescription;
    }

    /**
     * 应用状态0:设计态；1:运行态
     */
    public Short getTenantState() {
        return tenantState;
    }

    /**
     * 应用状态0:设计态；1:运行态
     */
    public void setTenantState(Short tenantState) {
        this.tenantState = tenantState;
    }

    /**
     * 建设单位
     */
    public String getTenantUnit() {
        return tenantUnit;
    }

    /**
     * 建设单位
     */
    public void setTenantUnit(String tenantUnit) {
        this.tenantUnit = tenantUnit;
    }

    /**
     * 所属公司编码
     */
    public String getOwnerCompanyCode() {
        return ownerCompanyCode;
    }

    /**
     * 所属公司编码
     */
    public void setOwnerCompanyCode(String ownerCompanyCode) {
        this.ownerCompanyCode = ownerCompanyCode;
    }

    /**
     * 所属公司名称
     */
    public String getOwnerCompanyName() {
        return ownerCompanyName;
    }

    /**
     * 所属公司名称
     */
    public void setOwnerCompanyName(String ownerCompanyName) {
        this.ownerCompanyName = ownerCompanyName;
    }

    /**
     * 是否删除0:否;1:是
     */
    public Short getIsDelete() {
        return isDelete;
    }

    /**
     * 是否删除0:否;1:是
     */
    public void setIsDelete(Short isDelete) {
        this.isDelete = isDelete;
    }

    /**
     * 所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区
     */
    public Short getTenantZone() {
        return tenantZone;
    }

    /**
     * 所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区
     */
    public void setTenantZone(Short tenantZone) {
        this.tenantZone = tenantZone;
    }

    /**
     * 所属层级 1:应用层;2:平台层;3:网络层;4:感知层;
     */
    public Short getTenantLayer() {
        return tenantLayer;
    }

    /**
     * 所属层级 1:应用层;2:平台层;3:网络层;4:感知层;
     */
    public void setTenantLayer(Short tenantLayer) {
        this.tenantLayer = tenantLayer;
    }

    /**
     * 应用版本（当前版本）
     */
    public String getTenantVersion() {
        return tenantVersion;
    }

    /**
     * 应用版本（当前版本）
     */
    public void setTenantVersion(String tenantVersion) {
        this.tenantVersion = tenantVersion;
    }
//
//    @Override
//    public boolean equals(Object that) {
//        if (this == that) {
//            return true;
//        }
//        if (that == null) {
//            return false;
//        }
//        if (getClass() != that.getClass()) {
//            return false;
//        }
//        OcpTenantBase other = (OcpTenantBase) that;
//        return (this.getObjId() == null ? other.getObjId() == null : this.getObjId().equals(other.getObjId()))
//            && (this.getTenantName() == null ? other.getTenantName() == null : this.getTenantName().equals(other.getTenantName()))
//            && (this.getTenantCode() == null ? other.getTenantCode() == null : this.getTenantCode().equals(other.getTenantCode()))
//            && (this.getTenantGroupCode() == null ? other.getTenantGroupCode() == null : this.getTenantGroupCode().equals(other.getTenantGroupCode()))
//            && (this.getTenantIp() == null ? other.getTenantIp() == null : this.getTenantIp().equals(other.getTenantIp()))
//            && (this.getTenantUrl() == null ? other.getTenantUrl() == null : this.getTenantUrl().equals(other.getTenantUrl()))
//            && (this.getProfessionalKind() == null ? other.getProfessionalKind() == null : this.getProfessionalKind().equals(other.getProfessionalKind()))
//            && (this.getTenantUserId() == null ? other.getTenantUserId() == null : this.getTenantUserId().equals(other.getTenantUserId()))
//            && (this.getTenantOrderNo() == null ? other.getTenantOrderNo() == null : this.getTenantOrderNo().equals(other.getTenantOrderNo()))
//            && (this.getTenantCtime() == null ? other.getTenantCtime() == null : this.getTenantCtime().equals(other.getTenantCtime()))
//            && (this.getTenantMtime() == null ? other.getTenantMtime() == null : this.getTenantMtime().equals(other.getTenantMtime()))
//            && (this.getDeploymentName() == null ? other.getDeploymentName() == null : this.getDeploymentName().equals(other.getDeploymentName()))
//            && (this.getTenantDescription() == null ? other.getTenantDescription() == null : this.getTenantDescription().equals(other.getTenantDescription()))
//            && (this.getTenantState() == null ? other.getTenantState() == null : this.getTenantState().equals(other.getTenantState()))
//            && (this.getTenantUnit() == null ? other.getTenantUnit() == null : this.getTenantUnit().equals(other.getTenantUnit()))
//            && (this.getOwnerCompanyCode() == null ? other.getOwnerCompanyCode() == null : this.getOwnerCompanyCode().equals(other.getOwnerCompanyCode()))
//            && (this.getOwnerCompanyName() == null ? other.getOwnerCompanyName() == null : this.getOwnerCompanyName().equals(other.getOwnerCompanyName()))
//            && (this.getIsDelete() == null ? other.getIsDelete() == null : this.getIsDelete().equals(other.getIsDelete()))
//            && (this.getTenantZone() == null ? other.getTenantZone() == null : this.getTenantZone().equals(other.getTenantZone()))
//            && (this.getTenantLayer() == null ? other.getTenantLayer() == null : this.getTenantLayer().equals(other.getTenantLayer()))
//            && (this.getTenantVersion() == null ? other.getTenantVersion() == null : this.getTenantVersion().equals(other.getTenantVersion()));
//    }
//
//    @Override
//    public int hashCode() {
//        final int prime = 31;
//        int result = 1;
//        result = prime * result + ((getObjId() == null) ? 0 : getObjId().hashCode());
//        result = prime * result + ((getTenantName() == null) ? 0 : getTenantName().hashCode());
//        result = prime * result + ((getTenantCode() == null) ? 0 : getTenantCode().hashCode());
//        result = prime * result + ((getTenantGroupCode() == null) ? 0 : getTenantGroupCode().hashCode());
//        result = prime * result + ((getTenantIp() == null) ? 0 : getTenantIp().hashCode());
//        result = prime * result + ((getTenantUrl() == null) ? 0 : getTenantUrl().hashCode());
//        result = prime * result + ((getProfessionalKind() == null) ? 0 : getProfessionalKind().hashCode());
//        result = prime * result + ((getTenantUserId() == null) ? 0 : getTenantUserId().hashCode());
//        result = prime * result + ((getTenantOrderNo() == null) ? 0 : getTenantOrderNo().hashCode());
//        result = prime * result + ((getTenantCtime() == null) ? 0 : getTenantCtime().hashCode());
//        result = prime * result + ((getTenantMtime() == null) ? 0 : getTenantMtime().hashCode());
//        result = prime * result + ((getDeploymentName() == null) ? 0 : getDeploymentName().hashCode());
//        result = prime * result + ((getTenantDescription() == null) ? 0 : getTenantDescription().hashCode());
//        result = prime * result + ((getTenantState() == null) ? 0 : getTenantState().hashCode());
//        result = prime * result + ((getTenantUnit() == null) ? 0 : getTenantUnit().hashCode());
//        result = prime * result + ((getOwnerCompanyCode() == null) ? 0 : getOwnerCompanyCode().hashCode());
//        result = prime * result + ((getOwnerCompanyName() == null) ? 0 : getOwnerCompanyName().hashCode());
//        result = prime * result + ((getIsDelete() == null) ? 0 : getIsDelete().hashCode());
//        result = prime * result + ((getTenantZone() == null) ? 0 : getTenantZone().hashCode());
//        result = prime * result + ((getTenantLayer() == null) ? 0 : getTenantLayer().hashCode());
//        result = prime * result + ((getTenantVersion() == null) ? 0 : getTenantVersion().hashCode());
//        return result;
//    }
//
//    @Override
//    public String toString() {
//        StringBuilder sb = new StringBuilder();
//        sb.append(getClass().getSimpleName());
//        sb.append(" [");
//        sb.append("Hash = ").append(hashCode());
//        sb.append(", objId=").append(objId);
//        sb.append(", tenantName=").append(tenantName);
//        sb.append(", tenantCode=").append(tenantCode);
//        sb.append(", tenantGroupCode=").append(tenantGroupCode);
//        sb.append(", tenantIp=").append(tenantIp);
//        sb.append(", tenantUrl=").append(tenantUrl);
//        sb.append(", professionalKind=").append(professionalKind);
//        sb.append(", tenantUserId=").append(tenantUserId);
//        sb.append(", tenantOrderNo=").append(tenantOrderNo);
//        sb.append(", tenantCtime=").append(tenantCtime);
//        sb.append(", tenantMtime=").append(tenantMtime);
//        sb.append(", deploymentName=").append(deploymentName);
//        sb.append(", tenantDescription=").append(tenantDescription);
//        sb.append(", tenantState=").append(tenantState);
//        sb.append(", tenantUnit=").append(tenantUnit);
//        sb.append(", ownerCompanyCode=").append(ownerCompanyCode);
//        sb.append(", ownerCompanyName=").append(ownerCompanyName);
//        sb.append(", isDelete=").append(isDelete);
//        sb.append(", tenantZone=").append(tenantZone);
//        sb.append(", tenantLayer=").append(tenantLayer);
//        sb.append(", tenantVersion=").append(tenantVersion);
//        sb.append(", serialVersionUID=").append(serialVersionUID);
//        sb.append("]");
//        return sb.toString();
//    }
}