package com.pms.ocp.model.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;

/**
 * 模型分类表(OcpModelGroupMapper)实体类
 *
 * @author huxiuwu
 * @since 2022-03-08 11:12:56
 */
@Data
@TableName("ocp_model_group")
public class OcpModelGroupVO implements Serializable {
    private static final long serialVersionUID = 800319672890485601L; 
   
    /**
    * 主键
    */
    @ApiModelProperty(value = "主键")
    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;
    /**
    * 模型分类名称
    */
    @ApiModelProperty(value = "模型分类名称")
    private String modelGroupName;
    /**
    * 模型分类编码
    */
    @ApiModelProperty(value = "模型分类编码")
    private String modelGroupCode;
    /**
    * 上级模型分类id
    */
    @ApiModelProperty(value = "上级模型分类id")
    private String modelGroupPcode;

    /**
     * 上级模型分类id
     */
    @ApiModelProperty(value = "上级模型分类名称")
    @TableField(exist = false)
    private String modelGroupPName;
    /**
    * 分类版本
    */
    @ApiModelProperty(value = "分类版本")
    private String groupVersion;
    /**
    * 展示顺序
    */
    @ApiModelProperty(value = "展示顺序")
    private Integer groupOrderNo;
    /**
    * 所属公司
    */
    @ApiModelProperty(value = "所属公司")
    private String groupCompanyCode;
    /**
    * 提交人id
    */
    @ApiModelProperty(value = "提交人id")
    private String groupUserId;
    /**
    * 提交人姓名
    */
    @ApiModelProperty(value = "提交人姓名")
    private String groupUserName;
    /**
    * 创建时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date groupCtime;
    /**
    * 修改时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "修改时间")
    private Date groupMtime;
    /**
    * 是否已删除0未删除 1未删除
    */
    @ApiModelProperty(value = "是否已删除0未删除 1未删除")
    private Integer isDelete;

    @TableField(exist = false)
    @ApiModelProperty(value = "层级")
    private int level;
    /**
     * 子类集合
     */
    @TableField(exist = false)
    @ApiModelProperty(value = "子类集合")
    private List<OcpModelGroupVO> childrenList;

    public String getModelGroupCode() {
        return modelGroupCode == null ? "" : modelGroupCode;
    }

    public String getModelGroupPcode() {
        return modelGroupPcode == null ? "" : modelGroupPcode;
    }

}
 
 


