package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.pms.ocp.common.utils.RandomStringUtils;
import com.pms.ocp.mapper.OcpApiBaseMapper;
import com.pms.ocp.mapper.OcpApiTreeMapper;
import com.pms.ocp.model.dto.*;
import com.pms.ocp.model.entity.OcpApiGroup;

import com.pms.ocp.service.OcpApiTreeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;


@Service
@Slf4j
public class OcpApiTreeServiceImpl extends ServiceImpl<OcpApiTreeMapper,OcpApiGroup> implements OcpApiTreeService {


    @Autowired
    private OcpApiTreeMapper mapper;

    @Autowired
    private OcpApiBaseMapper ocpApiBaseMapper;

    /**
     * 服务树分类
     *
     * @return
     */

    @Override
    public List<OcpApiGroup> getByGroup(Long apiGroupPromotionType,String apiGroupCode) {

//        if (StringUtils.isBlank(apiGroupPromotionType) && StringUtils.isBlank(apiGroupCode)) {
            // List<OcpApiGroup> ocpApiGroups = mapper.selectApiGroups();
            // return ocpApiGroups;
//       }else
            if (!("".equals(apiGroupPromotionType)) && StringUtils.isBlank(apiGroupCode)){
                List<OcpApiGroup> ocpApiGroups = mapper.selectTwoApiGroups(apiGroupPromotionType);
                return ocpApiGroups;
            } else if(!("".equals(apiGroupPromotionType)) && !(StringUtils.isBlank(apiGroupCode))){
                List<OcpApiGroup> ocpApiGroups = mapper.selectThreeApiGroupsList(apiGroupPromotionType, apiGroupCode);
                return ocpApiGroups;
            }

            return null;
        }


    /**
     * 新增服务分类
     *
     * @param
     */
    @Override
    public boolean insertTree(OcpApiGroup ocpApiGroup) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String code = RandomStringUtils.getRandomString(6);
        boolean flag = true;
               ocpApiGroup.setObjId("");
               ocpApiGroup.setApiGroupMtime(timestamp);
               ocpApiGroup.setApiGroupCtime(timestamp);
               ocpApiGroup.setApiGroupPcode(ocpApiGroup.getApiGroupCode());
               ocpApiGroup.setApiGroupCode(code);
               mapper.insert(ocpApiGroup);
        return flag;

    }


    /**
     * 修改服务分类
     *
     * @param
     */
    @Override
    public boolean updataOcpTree(OcpApiGroup ocpApiGroup) {
        boolean falg = true;
        List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);
        for (OcpApiGroup apiGroup : ocpApiGroups) {
            String code = apiGroup.getApiGroupCode();
            if (code == ocpApiGroup.getApiGroupCode()) {
                falg = false;
                break;
            }
        }
        mapper.updateById(ocpApiGroup);
        return falg;
    }


    /**
     * 删除服务分类
     *
     * @param ocpApiGroup
     */
    @Override
    public boolean deleteOcpTree(OcpApiGroup ocpApiGroup) {
        boolean flag = true;
        String objId = ocpApiGroup.getObjId();
        OcpApiGroup ocpApiGroup1 = mapper.selectById(objId);
        List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);
        if (StringUtils.isBlank(ocpApiGroup1.getApiGroupPcode())) {
            for (OcpApiGroup apiGroup : ocpApiGroups) {
                if ((ocpApiGroup1.getApiGroupCode()).equals(apiGroup.getApiGroupPcode())){
                    flag = false;
                    break;
                }
            }

        }
        mapper.deleteById(objId);
        return flag;
    }


    /**
     * 服务列表分级查询
     *
     * @param pageGroupDto
     * @return
     */
    @Override
    public Page<OcpApiGroup> getOnePages(PageGroupDto pageGroupDto) {

        Page pageInfo = new Page(pageGroupDto.getPageSize(), pageGroupDto.getPageNum());
        if (StringUtils.isBlank(pageGroupDto.getApiGroupCode())){
            List<OcpApiGroup> ocpApiGroups = mapper.selectTwoApiGroups(pageGroupDto.getApiGroupPromotionType());
            pageInfo.setRecords(ocpApiGroups);
            LambdaQueryWrapper<OcpApiGroup> lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(OcpApiGroup::getApiGroupPromotionType,pageGroupDto.getApiGroupPromotionType());
            mapper.selectPage(pageInfo,lambdaQueryWrapper);
        }else if (!(StringUtils.isBlank(pageGroupDto.getApiGroupCode()))){
            List<OcpApiGroup> ocpApiGroups = mapper.selectLists(pageGroupDto.getApiGroupPromotionType(),pageGroupDto.getApiGroupCode(),pageGroupDto.getApiGroupLevel());
            LambdaQueryWrapper<OcpApiGroup> lwq = new LambdaQueryWrapper<>();
            pageInfo.setRecords(ocpApiGroups);
            mapper.selectPage(pageInfo, lwq);
        }
        return pageInfo;
    }
}
