package com.pms.ocp.service.impl;



import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.common.utils.RandomStringUtils;
import com.pms.ocp.mapper.TenantBasicManagementMapper;
import com.pms.ocp.mapper.TenantMapper;
import com.pms.ocp.model.dto.*;
import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.service.TenantService;
import com.zaxxer.hikari.util.IsolationLevel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.sql.Timestamp;
import java.util.*;


@Service
public class TenantServiceImpl extends ServiceImpl<TenantMapper, OcpTenantGroup> implements TenantService {


    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private TenantBasicManagementMapper tenantBasicMapper;

    /**
     * 应用树分类管理
     *
     * @return
     */
        @Override
        public List<OcpTenantGroup> getTree(String tenantGroupCompanyCode ,String tenantGroupCode) {
            List<OcpTenantGroup> ocpTenantGroupList = null;
        if (StringUtils.isBlank(tenantGroupCode)  && StringUtils.isBlank(tenantGroupCompanyCode)){
            //顶级目录
            ocpTenantGroupList = tenantMapper.oneTenantGroup();
        }else if (!(StringUtils.isBlank(tenantGroupCompanyCode)) && StringUtils.isBlank(tenantGroupCode)){
            //二级目录
            ocpTenantGroupList = tenantMapper.selectGroups(tenantGroupCompanyCode);
        }
        else if (!(StringUtils.isBlank(tenantGroupCompanyCode)) &&!(StringUtils.isBlank(tenantGroupCompanyCode))){
                //三级目录
            ocpTenantGroupList = tenantMapper.selectTenantGroups(tenantGroupCode,tenantGroupCompanyCode);


        }
            return ocpTenantGroupList;
    }

    /**
     * 应用新增
     *
     * @param
     * @return
     */
    @Override
    public boolean getTenanInster(TenanBaseDto tenanBaseDto) {
        boolean falg = true;

        OcpTenantGroup group = new OcpTenantGroup();
        String tenantGroupCode = tenanBaseDto.getTenantGroupCode();
        List<OcpTenantGroup> ocpTenantGroups = tenantMapper.selectList(null);
        for (OcpTenantGroup tenantGroup : ocpTenantGroups) {
            if (tenantGroup.getTenantGroupCode().equals(tenantGroupCode)){
                falg = false;
                break;
            }
        }
        String randomString = RandomStringUtils.getRandomString(6);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        OcpTenantGroup ocpTenantGroup = new OcpTenantGroup();
        BeanUtils.copyProperties(tenanBaseDto,ocpTenantGroup);
        if ("null".equals(tenanBaseDto.getOwnerCompanyCode())){
            ocpTenantGroup.setTenantGroupCode(randomString);
        }
        ocpTenantGroup.setTenantGroupCtime(timestamp);
        ocpTenantGroup.setTenantGroupMtime(timestamp);
        if ("".equals(tenanBaseDto.getTenantVersion())){
            ocpTenantGroup.setTenantGroupVersion("1.0");
        }

        if ("null".equals(tenanBaseDto.getTenantGroupCode())){
            group.setTenantGroupCode(randomString);
        }
        tenantMapper.insert(tenanBaseDto);
        return falg;
    }

    /**
     * 修改应用
     *
     * @param ocpTenantGroup
     * @return
     */
    @Override
    public boolean getTenantUpdata(OcpTenantGroup ocpTenantGroup) {
        boolean falg = true;
        List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectList(null);
        for (OcpTenantGroup ocpApiGroup : ocpTenantGroupList) {
            String code = ocpTenantGroup.getTenantGroupCode();
            if (code == ocpApiGroup.getTenantGroupCode()) {
                falg = false;
                break;
            }
        }
       tenantMapper.updateById(ocpTenantGroup);

        return falg;
    }

    /**
     * 删除服务
     *
     * @param ocpTenantGroup
     * @return
     */
    @Override
    public boolean gettenantDelete(OcpTenantGroup ocpTenantGroup) {
        String objId = ocpTenantGroup.getObjId();
        OcpTenantGroup ocpTenantGroup1 = tenantMapper.selectById(objId);
        boolean flag = true;
        List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectList(null);
        if (StringUtils.isBlank(ocpTenantGroup1.getTenantGroupPcode())) {
            for (OcpTenantGroup tenantGroup : ocpTenantGroupList) {
                String tenantGroupPcode = tenantGroup.getTenantGroupPcode();
                if ((ocpTenantGroup.getTenantGroupCode().equals(tenantGroupPcode))){
                    flag = false;
                    break;
                }
            }
        }

        tenantMapper.deleteById(objId);

        return flag;
    }

    /**
     * 应用--查询
     *
     * @param tenantGroupCode
     * @param tenantGroupCompanyCode
     * @return
     */
    @Override
    public Page<OcpTenantGroup> getselects(String tenantGroupCode,String tenantGroupCompanyCode,int currentPage,int pageSize,String keyword) {
        LambdaQueryWrapper<OcpTenantGroup> qw = new LambdaQueryWrapper<>();
        List<OcpTenantGroup> ocpTenantGroupList1 = tenantMapper.selectList(null);
        Page<OcpTenantGroup> page = new Page<>(currentPage, pageSize);
        if ("".equals(keyword)) {
            if (StringUtils.isBlank(tenantGroupCode)) {
                for (OcpTenantGroup ocpTenantGroup : ocpTenantGroupList1) {
                    if (ocpTenantGroup.getTenantGroupPcode().equals(tenantGroupCode) && ocpTenantGroup.getTenantGroupCompanyCode().equals(tenantGroupCompanyCode)){
                        List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectTenantGroup(tenantGroupCompanyCode);
                        page.setRecords(ocpTenantGroupList);
                        tenantMapper.selectPage(page,qw);
                    }
                }
            } else {
                for (OcpTenantGroup ocpTenantGroup : ocpTenantGroupList1) {
                    if (ocpTenantGroup.getTenantGroupPcode().equals(tenantGroupCode) && ocpTenantGroup.getTenantGroupCompanyCode().equals(tenantGroupCompanyCode)) {
                        List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectTenantGroups(tenantGroupCode, tenantGroupCompanyCode);
                        page.setRecords(ocpTenantGroupList);
                        tenantMapper.selectPage(page,qw);
                    }
                }
            }
            return page;
        }else {
            List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.queryLike(keyword);
            page.setRecords(ocpTenantGroupList);
            tenantMapper.selectPage(page,qw);
            return page;
        }

    }
}
