package com.pms.ocp.controller;

import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.AppArrangeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @className: AppArrangeController
 * @Dscription:应用分类管理接口
 *  * @atuthor: pei-chenxi
 *  * @DateTime: 2022/3/9 14:15e
 */
@Slf4j
@RestController
@RequestMapping("/app-arrange/vl")
@Api(tags = "应用分类管理接口")
public class AppArrangeController {


    @Autowired
    private AppArrangeService appArrangeService;

    @PostMapping("/update/app")
    @ApiOperation("应用分类修改")
    public ResponseVO updateApp(@RequestBody OcpTenantGroup ocpTenantGroup){
        boolean flag = appArrangeService.updateApp(ocpTenantGroup);
        if (flag){
            return ResponseVO.ok();
        }
        return ResponseVO.error("您输入的分类编码重复，请重新输入");
    }
}
