package com.pms.ocp.controller;


import com.github.pagehelper.PageInfo;
import com.pms.ocp.model.dto.*;

import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.TenantBasicManagementService;
import com.pms.ocp.service.TenantService;

import io.swagger.annotations.Api;

import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.sql.Timestamp;
import java.util.List;
/**
 * @author guofanfan
 */
@Slf4j
@RequestMapping("/tenant/basic")
@RestController
@Api(tags = "应用库服务基础管理接口")
public class TenantBasicManagementController {
    @Autowired
    private TenantBasicManagementService tenantBasicManagementService;
    @Autowired
    private TenantService tenantService;

    @ApiOperation("条件查询")
    @GetMapping("/queryOcpTenantBaseDto")
    public ResponseVO<List<OcpTenantBaseDto>> queryOcpTenantBaseDto(
            @RequestParam(required = false) String tenantGroupCode,
            @RequestParam(required = false) String tenantCode,
            @RequestParam(required = false) String keyword,
            @RequestParam(required = false) String tenantUnit,
            @RequestParam(required = false) Timestamp startTime,
            @RequestParam(required = false) Timestamp endTime,
            @RequestParam(required = false) Integer pageSize,
            @RequestParam(required = false) Integer pageNum
    ) {

        List<OcpTenantBaseDto> ocpTenantBaseDto = tenantBasicManagementService.queryOcpTenantBaseDto(tenantGroupCode, tenantCode, keyword, tenantUnit, startTime, endTime, pageSize, pageNum);
        return ResponseVO.ok(ocpTenantBaseDto);
    }

    @ApiOperation("应用发布")
    @GetMapping("/issue")
    public ResponseVO TenantIssue(
            @RequestParam(required = false) String tenantCodes) {

        return tenantBasicManagementService.tenantIssue(tenantCodes);
    }

    @ApiOperation("应用订阅")
    @GetMapping("/login")
    public ResponseVO TenantLogin(
            @RequestParam(required = false) String tenantCodes,
            @RequestParam(required = false) String companyCode) {

        return tenantBasicManagementService.tenantLogin(tenantCodes, companyCode);

    }

    @ApiOperation("应用下线")
    @GetMapping("/cancel")
    public ResponseVO TenantCancel(
            @RequestParam(required = false) String tenantCodes) {
        return tenantBasicManagementService.tenantCancel(tenantCodes);

    }

    @ApiOperation("应用注册")
    @PostMapping("/apply/register")
    public ResponseVO TenantRegister(@RequestBody(required = false) OcpTenantBaseDto ocpTenantBaseDto) {
        return tenantBasicManagementService.applyRegister(ocpTenantBaseDto);

    }

    @ApiOperation("应用树层级")
    @GetMapping("/tenantBaseTreeOther")
    public ResponseVO<List<GroupDto>> tenantBaseTreeOther(@RequestParam(required = false) String tenantGroupCode, @RequestParam(required = false) String tenantGroupCompanyCode
    ) {
        List<GroupDto> ocpApiGroups = tenantBasicManagementService.tenantBaseTreeOther(tenantGroupCode, tenantGroupCompanyCode);
        return ResponseVO.ok(ocpApiGroups);
    }

    @ApiOperation("应用树底层")
    @GetMapping("/tenantBaseTree")
    public ResponseVO<List<OcpTenantBase>> tenantBaseTree(@RequestParam(required = false) String tenantGroupCode,
                                                          @RequestParam(required = false) String tenantGroupCompanyCode) {
        if (StringUtils.isEmpty(tenantGroupCode)) {
            return ResponseVO.error("code为空");
        }
        List<OcpTenantBase> ocpTenantBases = tenantBasicManagementService.tenantBaseTree(tenantGroupCode, tenantGroupCompanyCode);
        return ResponseVO.ok(ocpTenantBases);
    }

    @ApiOperation("应用列表")
    @GetMapping("/tenantListQuery")
    public ResponseVO<PageInfo<OcpTenantBaseDto>> tenantListQuery(HttpServletRequest request, TenantDto tenantDto) {
        return tenantBasicManagementService.getBaseByGroupCode(tenantDto);
    }

    @ApiOperation("注册查询信息")
    @GetMapping("/select/register")
    public ResponseVO<OcpTenantGroup> selectRegister(@RequestParam(required = false) String tenantGroupCode, @RequestParam(required = false) String tenantGroupCompanyCode) {
        OcpTenantGroup ocpTenantGroup = tenantBasicManagementService.selectRegister(tenantGroupCode, tenantGroupCompanyCode);
        return ResponseVO.ok(ocpTenantGroup);
    }
}
