package com.pms.ocp.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import com.pms.ocp.model.dto.ApiTreeGroupDto;
import com.pms.ocp.model.entity.OcpApiGroup;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;


@Mapper
public interface OcpApiTreeMapper extends BaseMapper<OcpApiGroup> {

    /**
     *    一级树
     * @return
     */
  List<OcpApiGroup> selectApiGroups();


    /**
     * 二级树
     * @param apiGroupPromotionType
     * @return
     */
    List<OcpApiGroup>  selectTwoApiGroups(Long apiGroupPromotionType);

    //三级数
    List<OcpApiGroup> selectThreeApiGroupsList(Long apiGroupPromotionType, String apiGroupCode);


  List<OcpApiGroup> selectLists(Long apiGroupPromotionType, String apiGroupCode);

//code重复问题
  List<OcpApiGroup> selectGroupCode();

  //根据code查询整条数据
  OcpApiGroup selectCode(String code);
}
