package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.sql.Date;
import java.sql.Timestamp;

@Data
@Accessors(chain = true)
@TableName("ocp_api_base")
@ApiModel("服务基础信息表")
public class OcpApiBase {


 @TableId(type = IdType.ASSIGN_ID)
  @ApiModelProperty("主键ID")
  private String objId;

  @ApiModelProperty("服务代码")
  private String apiCode;

  @ApiModelProperty("服务接口中文名称")
  private String apiName;

  @ApiModelProperty("服务分类代码")
  private String apiGroupCode;

  @ApiModelProperty("推广类型0:统建；1:自建")
  private long apiPromotion;

  @ApiModelProperty("服务请求体")
  private String apiReq;

  @ApiModelProperty("服务返回体")
  private String apiResp;

  @ApiModelProperty("服务地址")
  private String apiUrl;

  @ApiModelProperty("服务创建时间")
  private Timestamp apiCtime;

  @ApiModelProperty("服务修改时间")
  private Timestamp apiMtime;

  @ApiModelProperty("创建者用户ID")
  private String apiUserId;

  @ApiModelProperty("建设单位")
  private String apiUnit;

  @ApiModelProperty("服务所属公司")
  private String ownerCompanyCode;

//  @ApiModelProperty("服务所属公司")
//  private String ownerCompanyName;

  @ApiModelProperty("是否删除0-否1-是")
  private long isDelete;

  @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
  private long apiZone;

  @ApiModelProperty("'所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
  private long apiLayer;

  @ApiModelProperty("服务版本（最新版本）")
  private String apiVersion;

  @ApiModelProperty("服务所属中心编码所属中心")
  private String apiCenterCode;

  @ApiModelProperty("服务简述")
  private String apiDescription;

  @ApiModelProperty("创建者姓名")
  private String apiUserName;

    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getApiCode() {
        return apiCode;
    }

    public void setApiCode(String apiCode) {
        this.apiCode = apiCode;
    }

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getApiGroupCode() {
        return apiGroupCode;
    }

    public void setApiGroupCode(String apiGroupCode) {
        this.apiGroupCode = apiGroupCode;
    }

    public long getApiPromotion() {
        return apiPromotion;
    }

    public void setApiPromotion(long apiPromotion) {
        this.apiPromotion = apiPromotion;
    }

    public String getApiReq() {
        return apiReq;
    }

    public void setApiReq(String apiReq) {
        this.apiReq = apiReq;
    }

    public String getApiResp() {
        return apiResp;
    }

    public void setApiResp(String apiResp) {
        this.apiResp = apiResp;
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public Timestamp getApiCtime() {
        return apiCtime;
    }

    public void setApiCtime(Timestamp apiCtime) {
        this.apiCtime = apiCtime;
    }

    public Timestamp getApiMtime() {
        return apiMtime;
    }

    public void setApiMtime(Timestamp apiMtime) {
        this.apiMtime = apiMtime;
    }

    public String getApiUserId() {
        return apiUserId;
    }

    public void setApiUserId(String apiUserId) {
        this.apiUserId = apiUserId;
    }

    public String getApiUnit() {
        return apiUnit;
    }

    public void setApiUnit(String apiUnit) {
        this.apiUnit = apiUnit;
    }

    public String getOwnerCompanyCode() {
        return ownerCompanyCode;
    }

    public void setOwnerCompanyCode(String ownerCompanyCode) {
        this.ownerCompanyCode = ownerCompanyCode;
    }

    public long getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(long isDelete) {
        this.isDelete = isDelete;
    }

    public long getApiZone() {
        return apiZone;
    }

    public void setApiZone(long apiZone) {
        this.apiZone = apiZone;
    }

    public long getApiLayer() {
        return apiLayer;
    }

    public void setApiLayer(long apiLayer) {
        this.apiLayer = apiLayer;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getApiCenterCode() {
        return apiCenterCode;
    }

    public void setApiCenterCode(String apiCenterCode) {
        this.apiCenterCode = apiCenterCode;
    }

    public String getApiDescription() {
        return apiDescription;
    }

    public void setApiDescription(String apiDescription) {
        this.apiDescription = apiDescription;
    }

    public String getApiUserName() {
        return apiUserName;
    }

    public void setApiUserName(String apiUserName) {
        this.apiUserName = apiUserName;
    }
}
