package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import java.sql.Timestamp;

@Data
@Accessors(chain = true)
@TableName("ocp_api_subs")
@ApiModel("服务订阅记录表")
public class OcpApiSubs {

  @TableId(type = IdType.ASSIGN_ID)
  @ApiModelProperty("主键ID")
  private String objId;

  @ApiModelProperty("服务编码")
  private String apiCode;

  @ApiModelProperty("服务订阅创建时间")
  private Timestamp subsLogApiCtime;

  @ApiModelProperty("服务订阅修改时间")
  private Timestamp subsLogApiMtime;

  @ApiModelProperty("服务订阅创建用户ID")
  private String subsLogApiUserId;

  @ApiModelProperty("服务订阅添加时间")
  private Timestamp subsLogApiAtime;

  @ApiModelProperty("公司编码")
  private String subsCompanyCode;

  @ApiModelProperty("是否删除0-否，1-是")
  private long isDelete;

  public String getObjId() {
    return objId;
  }

  public void setObjId(String objId) {
    this.objId = objId;
  }

  public String getApiCode() {
    return apiCode;
  }

  public void setApiCode(String apiCode) {
    this.apiCode = apiCode;
  }

  public Timestamp getSubsLogApiCtime() {
    return subsLogApiCtime;
  }

  public void setSubsLogApiCtime(Timestamp subsLogApiCtime) {
    this.subsLogApiCtime = subsLogApiCtime;
  }

  public Timestamp getSubsLogApiMtime() {
    return subsLogApiMtime;
  }

  public void setSubsLogApiMtime(Timestamp subsLogApiMtime) {
    this.subsLogApiMtime = subsLogApiMtime;
  }

  public String getSubsLogApiUserId() {
    return subsLogApiUserId;
  }

  public void setSubsLogApiUserId(String subsLogApiUserId) {
    this.subsLogApiUserId = subsLogApiUserId;
  }

  public Timestamp getSubsLogApiAtime() {
    return subsLogApiAtime;
  }

  public void setSubsLogApiAtime(Timestamp subsLogApiAtime) {
    this.subsLogApiAtime = subsLogApiAtime;
  }

  public String getSubsCompanyCode() {
    return subsCompanyCode;
  }

  public void setSubsCompanyCode(String subsCompanyCode) {
    this.subsCompanyCode = subsCompanyCode;
  }

  public long getIsDelete() {
    return isDelete;
  }

  public void setIsDelete(long isDelete) {
    this.isDelete = isDelete;
  }
}
