package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * 应用信息表
 * @TableName ocp_tenant_base
 */
@Data
@Accessors(chain = true)
@TableName("ocp_tenant_base")
@ApiModel("应用信息表1")
public class PmsTenantBase implements Serializable {

    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    private String objId;


    @ApiModelProperty("应用名称")
    private String tenantName;


    @ApiModelProperty("应用代码")
    private String tenantCode;


    @ApiModelProperty("应用分类代码")
    private String tenantGroupCode;


    @ApiModelProperty("应用ip")
    private String tenantIp;


    @ApiModelProperty("应用url")
    private String tenantUrl;



    @ApiModelProperty("所属专业")
    private String professionalKind;


    @ApiModelProperty("创建者用户ID")
    private String tenantUserId;


    @ApiModelProperty("排序")
    private Integer tenantOrderNo;


    @ApiModelProperty("创建时间")
    private Timestamp tenantCtime;


    @ApiModelProperty("最后更新时间")
    private Timestamp tenantMtime;



    @ApiModelProperty("部署名称")
    private String deploymentName;


    @ApiModelProperty("描述")
    private String tenantDescription;


    @ApiModelProperty("应用状态0:设计态；1:运行态")
    private Short tenantState;

    @ApiModelProperty("推广类型0:统建；1:自建")
    private long tenantPromotion;

    @ApiModelProperty("建设单位")
    private String tenantUnit;


    @ApiModelProperty("所属公司编码")
    private String ownerCompanyCode;


    @ApiModelProperty("所属公司名称")
    private String ownerCompanyName;


    @ApiModelProperty("应用路径")
    private String tenantFullPath;


    @ApiModelProperty("是否删除0:否;1:是")
    private Short isDelete;


    @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
    private Short tenantZone;


    @ApiModelProperty("所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
    private Short tenantLayer;


    @ApiModelProperty("应用版本（当前版本）")
    private String tenantVersion;

    private static final long serialVersionUID = 1L;


//
//    @Override
//    public boolean equals(Object that) {
//        if (this == that) {
//            return true;
//        }
//        if (that == null) {
//            return false;
//        }
//        if (getClass() != that.getClass()) {
//            return false;
//        }
//        OcpTenantBase other = (OcpTenantBase) that;
//        return (this.getObjId() == null ? other.getObjId() == null : this.getObjId().equals(other.getObjId()))
//            && (this.getTenantName() == null ? other.getTenantName() == null : this.getTenantName().equals(other.getTenantName()))
//            && (this.getTenantCode() == null ? other.getTenantCode() == null : this.getTenantCode().equals(other.getTenantCode()))
//            && (this.getTenantGroupCode() == null ? other.getTenantGroupCode() == null : this.getTenantGroupCode().equals(other.getTenantGroupCode()))
//            && (this.getTenantIp() == null ? other.getTenantIp() == null : this.getTenantIp().equals(other.getTenantIp()))
//            && (this.getTenantUrl() == null ? other.getTenantUrl() == null : this.getTenantUrl().equals(other.getTenantUrl()))
//            && (this.getProfessionalKind() == null ? other.getProfessionalKind() == null : this.getProfessionalKind().equals(other.getProfessionalKind()))
//            && (this.getTenantUserId() == null ? other.getTenantUserId() == null : this.getTenantUserId().equals(other.getTenantUserId()))
//            && (this.getTenantOrderNo() == null ? other.getTenantOrderNo() == null : this.getTenantOrderNo().equals(other.getTenantOrderNo()))
//            && (this.getTenantCtime() == null ? other.getTenantCtime() == null : this.getTenantCtime().equals(other.getTenantCtime()))
//            && (this.getTenantMtime() == null ? other.getTenantMtime() == null : this.getTenantMtime().equals(other.getTenantMtime()))
//            && (this.getDeploymentName() == null ? other.getDeploymentName() == null : this.getDeploymentName().equals(other.getDeploymentName()))
//            && (this.getTenantDescription() == null ? other.getTenantDescription() == null : this.getTenantDescription().equals(other.getTenantDescription()))
//            && (this.getTenantState() == null ? other.getTenantState() == null : this.getTenantState().equals(other.getTenantState()))
//            && (this.getTenantUnit() == null ? other.getTenantUnit() == null : this.getTenantUnit().equals(other.getTenantUnit()))
//            && (this.getOwnerCompanyCode() == null ? other.getOwnerCompanyCode() == null : this.getOwnerCompanyCode().equals(other.getOwnerCompanyCode()))
//            && (this.getOwnerCompanyName() == null ? other.getOwnerCompanyName() == null : this.getOwnerCompanyName().equals(other.getOwnerCompanyName()))
//            && (this.getIsDelete() == null ? other.getIsDelete() == null : this.getIsDelete().equals(other.getIsDelete()))
//            && (this.getTenantZone() == null ? other.getTenantZone() == null : this.getTenantZone().equals(other.getTenantZone()))
//            && (this.getTenantLayer() == null ? other.getTenantLayer() == null : this.getTenantLayer().equals(other.getTenantLayer()))
//            && (this.getTenantVersion() == null ? other.getTenantVersion() == null : this.getTenantVersion().equals(other.getTenantVersion()));
//    }
//
//    @Override
//    public int hashCode() {
//        final int prime = 31;
//        int result = 1;
//        result = prime * result + ((getObjId() == null) ? 0 : getObjId().hashCode());
//        result = prime * result + ((getTenantName() == null) ? 0 : getTenantName().hashCode());
//        result = prime * result + ((getTenantCode() == null) ? 0 : getTenantCode().hashCode());
//        result = prime * result + ((getTenantGroupCode() == null) ? 0 : getTenantGroupCode().hashCode());
//        result = prime * result + ((getTenantIp() == null) ? 0 : getTenantIp().hashCode());
//        result = prime * result + ((getTenantUrl() == null) ? 0 : getTenantUrl().hashCode());
//        result = prime * result + ((getProfessionalKind() == null) ? 0 : getProfessionalKind().hashCode());
//        result = prime * result + ((getTenantUserId() == null) ? 0 : getTenantUserId().hashCode());
//        result = prime * result + ((getTenantOrderNo() == null) ? 0 : getTenantOrderNo().hashCode());
//        result = prime * result + ((getTenantCtime() == null) ? 0 : getTenantCtime().hashCode());
//        result = prime * result + ((getTenantMtime() == null) ? 0 : getTenantMtime().hashCode());
//        result = prime * result + ((getDeploymentName() == null) ? 0 : getDeploymentName().hashCode());
//        result = prime * result + ((getTenantDescription() == null) ? 0 : getTenantDescription().hashCode());
//        result = prime * result + ((getTenantState() == null) ? 0 : getTenantState().hashCode());
//        result = prime * result + ((getTenantUnit() == null) ? 0 : getTenantUnit().hashCode());
//        result = prime * result + ((getOwnerCompanyCode() == null) ? 0 : getOwnerCompanyCode().hashCode());
//        result = prime * result + ((getOwnerCompanyName() == null) ? 0 : getOwnerCompanyName().hashCode());
//        result = prime * result + ((getIsDelete() == null) ? 0 : getIsDelete().hashCode());
//        result = prime * result + ((getTenantZone() == null) ? 0 : getTenantZone().hashCode());
//        result = prime * result + ((getTenantLayer() == null) ? 0 : getTenantLayer().hashCode());
//        result = prime * result + ((getTenantVersion() == null) ? 0 : getTenantVersion().hashCode());
//        return result;
//    }
//
//    @Override
//    public String toString() {
//        StringBuilder sb = new StringBuilder();
//        sb.append(getClass().getSimpleName());
//        sb.append(" [");
//        sb.append("Hash = ").append(hashCode());
//        sb.append(", objId=").append(objId);
//        sb.append(", tenantName=").append(tenantName);
//        sb.append(", tenantCode=").append(tenantCode);
//        sb.append(", tenantGroupCode=").append(tenantGroupCode);
//        sb.append(", tenantIp=").append(tenantIp);
//        sb.append(", tenantUrl=").append(tenantUrl);
//        sb.append(", professionalKind=").append(professionalKind);
//        sb.append(", tenantUserId=").append(tenantUserId);
//        sb.append(", tenantOrderNo=").append(tenantOrderNo);
//        sb.append(", tenantCtime=").append(tenantCtime);
//        sb.append(", tenantMtime=").append(tenantMtime);
//        sb.append(", deploymentName=").append(deploymentName);
//        sb.append(", tenantDescription=").append(tenantDescription);
//        sb.append(", tenantState=").append(tenantState);
//        sb.append(", tenantUnit=").append(tenantUnit);
//        sb.append(", ownerCompanyCode=").append(ownerCompanyCode);
//        sb.append(", ownerCompanyName=").append(ownerCompanyName);
//        sb.append(", isDelete=").append(isDelete);
//        sb.append(", tenantZone=").append(tenantZone);
//        sb.append(", tenantLayer=").append(tenantLayer);
//        sb.append(", tenantVersion=").append(tenantVersion);
//        sb.append(", serialVersionUID=").append(serialVersionUID);
//        sb.append("]");
//        return sb.toString();
//    }
}