package com.pms.ocp.service;


import com.pms.ocp.model.dto.ModelRelationDTO;
import com.pms.ocp.model.entity.ModelRelation;
import com.pms.ocp.model.vo.ModelRelationVO;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:07
 * @Description:模型关系业务层接口
 */
public interface ModelRelationService {

    /**
     * 创建模型关系
     *
     * @param modelRelationDTO
     * @return
     */
    Integer createModelRelation(ModelRelationDTO modelRelationDTO);

    /**
     * 删除模型关系
     *
     * @param objId
     * @param modelCode
     * @return
     */
    Integer deleteModelRelation(String objId, String modelCode);

    /**
     * 批量删除模型关系
     *
     * @param ids
     * @return
     */
    Integer deleteBatchModelRelation(List<String> ids);

    /**
     * 更新模型关系
     *
     * @param modelRelation
     * @return
     */
    Integer updateModelRelation(ModelRelation modelRelation);

    /**
     * 获取模型关系
     *
     * @param
     * @return
     */
    List<ModelRelation> getModelRelationList(String objId, String modelGroupCode, String modelCode);

    /**
     * 获取模型关系列表
     *
     * @param modelId
     * @return
     */
    ModelRelationVO getModelRelation(String modelId);
}
