package com.pms.ocp.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.pms.ocp.common.constants.CodeEnum;
import com.pms.ocp.common.utils.TreeUtils;
import com.pms.ocp.mapper.ModelSubscribeMapper;
import com.pms.ocp.model.dto.ModelSubscribeDTO;
import com.pms.ocp.model.entity.ModelSubscribe;
import com.pms.ocp.model.entity.TreeNode;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ModelSubscribeService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:22
 * @Description:模型订阅业务层实现
 */

@Service
public class ModelSubscribeServiceImpl implements ModelSubscribeService {

    @Resource
    private ModelSubscribeMapper modelSubscribeMapper;

    @Override
    public Integer createModelSubscribe(ModelSubscribeDTO modelSubscribeDTO) {

        ModelSubscribe modelSubscribe = new ModelSubscribe();

        BeanUtils.copyProperties(modelSubscribeDTO, modelSubscribe);

        modelSubscribe.setSubsCtime(LocalDateTime.now());

        return modelSubscribeMapper.insert(modelSubscribe);
    }

    @Override
    public Integer deleteModelSubscribe(String modelId) {
        return null;
    }

    /**
     * 批量删除模型订阅
     *
     * @param ids
     * @return
     */
    @Override
    public Integer deleteBatchModelSubscribe(List<String> ids) {
        return modelSubscribeMapper.deleteBatchIds(ids);
    }

    @Override
    public Integer updateModelSubscribe(ModelSubscribe modelSubscribe) {
        return null;
    }

    @Override
    public List<ModelSubscribe> getModelSubscribeList(String objId, String modelCode, String subsCompanyCode) {
        QueryWrapper<ModelSubscribe> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(ModelSubscribe::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelSubscribe::getModelCode, modelCode);
        }

        if (StringUtils.isNotEmpty(subsCompanyCode)) {
            queryWrapper.lambda().eq(ModelSubscribe::getSubsCompanyCode, subsCompanyCode);
        }

        return modelSubscribeMapper.selectList(queryWrapper);
    }

    @Override
    public ModelSubscribeDTO getModelSubscribe(String modelId) {
        return null;
    }


    /**
     * 服务列表导航树
     * @author huxiuwu
     * @date 2022/3/11
     *
     * @return pms.ocp.model.vo.ResponseVO
     **/
    @Override
    public ResponseVO modelListNavigation(String searchCondition) {
        //查询模型和模型属性表列表
        List<TreeNode> modelProperList =  modelSubscribeMapper.selectModelAndModelGroup(searchCondition);
        if (CollectionUtil.isEmpty(modelProperList)){
            return ResponseVO.error(CodeEnum.NO_DATA);
        }
        List<TreeNode> modelGroupList = TreeUtils.build(modelProperList);
        //查询组织机构表
        List<TreeNode> organList = modelSubscribeMapper.selectOrganData();
        //将分类放入各自所属于的组织机构下
        organList.forEach(org
                ->{
            modelGroupList.forEach(group->{
                if (org.getCompanyCode().equals(group.getCompanyCode())){
                    if(org.getChildren() == null){
                        org.setChildren(new LinkedList<>());
                    }
                    org.getChildren().add(group);
                }
            });
        });
        List<TreeNode> result = TreeUtils.build(organList);
        return ResponseVO.ok(result);
    }
}
