package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.mapper.OcpApiTenantRelMapper;
import com.pms.ocp.mapper.PmsApiTenantRelMapper;
import com.pms.ocp.model.entity.OcpApiTenantRel;
import com.pms.ocp.model.entity.PmsApiTenantRel;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.PmsApiTenantRelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class PmsApiTenantRelServiceImpl extends ServiceImpl<PmsApiTenantRelMapper, PmsApiTenantRel> implements PmsApiTenantRelService {
    @Autowired
    private PmsApiTenantRelMapper pmsApiTenantRelMapper;


    @Override
    public ResponseVO getOatrList(PmsApiTenantRel pmsApiTenantRel) {
        List<PmsApiTenantRel> oatrList = pmsApiTenantRelMapper.getOatrList(pmsApiTenantRel);
        return ResponseVO.ok(oatrList);
    }

    @Override
    public ResponseVO getTenantApiList(PmsApiTenantRel pmsApiTenantRel) {
        List<PmsApiTenantRel> oatrList = pmsApiTenantRelMapper.getTenantApiList(pmsApiTenantRel);
        return ResponseVO.ok(oatrList);
    }
}
