package com.pms.ocp.common.utils;

import com.pms.ocp.model.entity.TreeNode;

import java.util.*;

/**
 * @author huxiuwu
 * @version 1.0
 * @date 2022/3/8 17:51
 */
public class TreeUtils {
    /**
     * 根据pid，构建树节点
     */
    public static <T extends TreeNode> List<T> build(List<T> treeNodes, Long pid) {

        List<T> treeList = new ArrayList<>();
        for(T treeNode : treeNodes) {
            if (pid.equals(treeNode.getpCode())) {
                treeList.add(findChildren(treeNodes, treeNode));
            }
        }

        return treeList;
    }

    /**
     * 查找子节点
     */
    private static <T extends TreeNode> T findChildren(List<T> treeNodes, T rootNode) {
        for(T treeNode : treeNodes) {
            if(rootNode.getCode().equals(treeNode.getpCode())) {
                rootNode.getChildren().add(findChildren(treeNodes, treeNode));
            }
        }
        return rootNode;
    }

    /**
     * 构建树节点
     */
    public static <T extends TreeNode> List<T> build(List<T> treeNodes) {
        List<T> result = new ArrayList<>();

        //list转map
        Map<String, T> nodeMap = new LinkedHashMap<>(treeNodes.size());
        for(T treeNode : treeNodes){
            nodeMap.put(treeNode.getCode(), treeNode);
        }

        for(T node : nodeMap.values()) {
            T parent = nodeMap.get(node.getpCode());
            if(parent != null && (node.getpCode().equals(parent.getCode()))
                    && (!"".equals(node.getpCode())|| !"".equals(parent.getCode()))){
                if (parent.getChildren() == null){
                    parent.setChildren(new LinkedList<>());
                }
                parent.getChildren().add(node);
                continue;
            }
            result.add(node);
        }

        return result;
    }

}
