package com.pms.ocp.controller;

import com.pms.ocp.model.entity.*;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.OcpApiTenantRelService;
import com.pms.ocp.service.OcpTenantAuditService;
import com.pms.ocp.service.OcpTenantBaseService;
import com.pms.ocp.service.OcpTenantSubsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Slf4j
@RequestMapping("/tenant")
@RestController
@Api(tags = "应用接口")
public class OcpTenantDetailsController {

    @Autowired
    private OcpTenantBaseService ocpTenantBaseService;

    @Autowired
    private OcpTenantAuditService ocpTenantAuditService;

    @Autowired
    private OcpTenantSubsService ocpTenantSubsService;

    @Autowired
    private OcpApiTenantRelService ocpApiTenantRelService;


    @ApiOperation("应用基础信息-查询")
    @PostMapping("/getotbList")
    public ResponseVO<List<OcpTenantBase>> getOtbList(@RequestBody OcpTenantBase ocpTenantBase){
        return ocpTenantBaseService.getOtbList(ocpTenantBase);
    }

    @ApiOperation("应用大事记-查询")
    @PostMapping("/getotaList")
    public ResponseVO<List<OcpApiAudit>> getOtaList(OcpTenantAudit ocpTenantAudit) {
        return ocpTenantAuditService.getOtaList(ocpTenantAudit);
    }

    @ApiOperation("应用大事记-查询详情")
    @PostMapping("/getotaListById")
    public ResponseVO<List<OcpApiAudit>> getOtaListById(@RequestBody OcpTenantAudit ocpTenantAudit) {
        return ocpTenantAuditService.getOtaListById(ocpTenantAudit);
    }

    @ApiOperation("应用订阅记录-查询")
    @PostMapping("/getOcpTenantList")
    public ResponseVO<List<OcpTenantSubs>> getOcpTenantList(OcpTenantSubs ocpTenantSubs) {
        return ocpTenantSubsService.getOcpTenantList(ocpTenantSubs);
    }

    @ApiOperation("应用与服务拓扑图-查询")
    @PostMapping("/getOcpTenantApiList")
    public ResponseVO<List<OcpApiTenantRel>> getOcpTenantApiList(@RequestBody OcpApiTenantRel ocpApiTenantRel) {
        return ocpApiTenantRelService.getTenantApiList(ocpApiTenantRel);
    }

    @ApiOperation("应用大事记-导出")
    @RequestMapping("/export")
    public void exportExcel(@RequestBody(required = false)OcpTenantAudit ocpTenantAudit, HttpServletRequest request, HttpServletResponse response) {
        ocpTenantAuditService.exportExcel(ocpTenantAudit,request,response);
    }
    @ApiOperation("应用大事记-查询详情-变更内容")
    @PostMapping("/getocpTent")
    public ResponseVO<List<OcpTenantAudit>> getOcpTenant(@RequestBody OcpTenantAudit ocpTenantAudit){
        return ocpTenantAuditService.OtaById(ocpTenantAudit);
    }
}
