package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:26
 * @Description:模型对象
 */

@Data
@Accessors(chain = true)
@TableName("ocp_model_base")
public class Model {

    /**
     * 模型关系编号
     * 主键
     */
    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 模型名称
     */
    private String modelName;

    /**
     * 模型编码
     */
    private String modelCode;

    /**
     * 设备类型
     */
    private String equipType;

    /**
     * 所属专业ts:输电,t:变电, dc:直流，ds配电，tc:技术，pl计划 im综合
     */
    private String professional_kind;

    /**
     * 模型分类编码
     */
    private String model_group_code;

    /**
     * 模型表名称
     */
    private String model_table;

    /**
     * 是否启用 0:未启用,1：启用
     */
    @TableField(value = "is_use")
    private Integer boolUse;


    /**
     * 模型推广类型 0:统推,1：自建
     */
    private Integer modelPromotion;

    /**
     * 公司编码
     */
    private String ownerCompanyCode;

    /**
     * 排列顺序
     */
    private Integer modelOrderNo;

    /**
     * 提交人id
     */
    private String modelUserId;


    /**
     * 提交人姓名
     */
    private String modelUserName;

    /**
     * 模型创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelCtime;

    /**
     * 模型修改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelMtime;

    /**
     * 是否已删除0:未删除 1:已删除
     */

    @TableField(value = "is_delete")
    private Integer boolDelete;

    /**
     * 所属区域1:生成控制大区 2:信息关联大区3:互联网大区
     */
    private Integer modelZone;

    /**
     * 所属层级1:应用层 2:平台层3:网络层 4:感知层
     */
    private Integer modelLayer;

    /**
     * 模型版本模型版本（最新版本）
     */
    private String modelVersion;

    /**
     * 建设厂商
     */
    private String apiUnit;
}

//    create table ocp_model_base
//        (
//                obj_id             varchar(42)                                not null
//        constraint ocp_model_base_pkey
//        primary key,
//        model_name         varchar(50)  default ''::character varying not null,
//        model_code         varchar(42)  default ''::character varying not null,
//        equip_type         varchar(42)  default ''::character varying,
//        professional_kind  varchar(10)  default ''::character varying,
//        model_group_code   varchar(42)  default ''::character varying,
//        model_table        varchar(50)  default ''::character varying,
//        is_use             smallint     default '-1'::integer,
//        model_promotion    smallint     default '-1'::integer,
//        owner_company_code varchar(42)  default ''::character varying not null,
//        model_order_no     integer      default '-1'::integer,
//        model_user_id      varchar(42)  default ''::character varying,
//        model_user_name    varchar(64)  default ''::character varying,
//        model_ctime        timestamp(6) default '2000-01-01 00:00:00'::timestamp(0) without time zone,
//        model_mtime        timestamp(6) default '2000-01-01 00:00:00'::timestamp(0) without time zone,
//        is_delete          smallint     default '-1'::integer,
//        model_zone         smallint     default '-1'::integer,
//        model_layer        smallint     default '-1'::integer,
//        model_version      varchar(10)  default ''::character varying,
//        api_unit           varchar(50)  default ''::character varying
//        );
//
//        comment on table ocp_model_base is '模型基础信息表';

//        comment on column ocp_model_base.obj_id is '主键';
//        comment on column ocp_model_base.model_name is '模型名称';
//        comment on column ocp_model_base.model_code is '模型编码';
//        comment on column ocp_model_base.equip_type is '设备类型';
//        comment on column ocp_model_base.professional_kind is '所属专业ts:输电,t:变电, dc:直流，ds配电，tc:技术，pl计划 im综合';
//        comment on column ocp_model_base.model_group_code is '模型分类编码';
//        comment on column ocp_model_base.model_table is '模型表(表的英文名称)表的英文名称';
//        comment on column ocp_model_base.is_use is '是否启用0:未启用,1：启用';
//        comment on column ocp_model_base.model_promotion is '推广类型0:统推 1自建';
//        comment on column ocp_model_base.owner_company_code is '公司code';
//        comment on column ocp_model_base.model_order_no is '排列顺序';
//        comment on column ocp_model_base.model_user_id is '提交人id';
//        comment on column ocp_model_base.model_user_name is '提交人姓名';
//        comment on column ocp_model_base.model_ctime is '创建时间';
//        comment on column ocp_model_base.model_mtime is '修改时间';
//        comment on column ocp_model_base.is_delete is '是否已删除0:未删除 1:已删除';
//        comment on column ocp_model_base.model_zone is '所属区域1:生成控制大区 2:信息关联大区3:互联网大区';
//        comment on column ocp_model_base.model_layer is '所属层级1:应用层 2:平台层3:网络层 4:感知层';
//        comment on column ocp_model_base.model_version is '模型版本模型版本（最新版本）';
//        comment on column ocp_model_base.api_unit is '建设厂商';
