package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:52
 * @Description:模型类型对象
 */
@Data
@Accessors(chain = true)
@TableName("ocp_model_group")
public class ModelClassify {

    /**
     * 模型分类编号
     */
    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 模型分类名称
     */
    private String modelGroupName;

    /**
     * 模型分类编码
     */
    private String modelGroupCode;

    /**
     * 上级模型分类编码
     */
    private String modelGroupPcode;

    /**
     * 分类版本
     */
    private String groupVersion;

    /**
     * 展示顺序
     */
    private Integer groupOrderNo;

    /**
     * 所属公司code
     */
    private String groupCompanyCode;

    /**
     * 提交人id
     */
    private String groupUserId;

    /**
     * 是否启用
     */
    private String groupUserName;

    /**
     * 模型创建时间
     */
    @TableField(value = "group_ctime")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date groupCreateTime;

    /**
     * 模型修改时间
     */
    @TableField(value = "group_mtime")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date groupUpdateTime;
}
