package com.pms.ocp.model.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:56
 * @Description:
 */

@Data
@NoArgsConstructor
//@AllArgsConstructor
@ApiModel(value = "中台运营管控_模型表", description = "中台运营管控_模型表")
public class ModelVO {

    /**
     * 模型编号
     * 主键
     */
    @Excel(name = "模型编号")
    @ApiModelProperty(value = "模型编号")
    private String objId;

    /**
     * 模型名称
     */
    @Excel(name = "模型名称")
    @ApiModelProperty(value = "模型名称")
    private String modelName;

    /**
     * 模型编码
     */
    @Excel(name = "模型编码")
    @ApiModelProperty(value = "模型编码")
    private String modelCode;

    /**
     * 设备类型
     */
    @Excel(name = "设备类型")
    @ApiModelProperty(value = "设备类型")
    private String equipType;

    /**
     * 所属专业 ts:输电,t:变电, dc:直流，ds:配电，tc:技术，pl:计划 im:综合
     */
    @Excel(name = "所属专业", replace = {"输电_ts", "变电_t", "直流_ds", "配电_ds", "技术_tc", "计划_pl", "综合_im"})
    @ApiModelProperty(value = "所属专业 ts:输电,t:变电, dc:直流，ds:配电，tc:技术，pl:计划 im:综合")
    private String professional_kind;

    /**
     * 模型分类编码
     */
    @Excel(name = "模型分类编码")
    @ApiModelProperty(value = "模型分类编码")
    private String model_group_code;

    /**
     * 模型表名称
     */
    @Excel(name = "模型表名称")
    @ApiModelProperty(value = "模型表名称")
    private String model_table;

    /**
     * 是否启用 0:未启用,1：启用
     */
    @Excel(name = "是否启用", replace = {"未启用_0", "启用_1"})
    @ApiModelProperty(value = "是否启用")
    private Integer boolUse;


    /**
     * 推广类型 0:统推,1：自建
     */
    @Excel(name = "推广类型", replace = {"统推_0", "自建_1"})
    @ApiModelProperty(value = "推广类型")
    private Integer modelPromotion;

    /**
     * 公司编码
     */
    @Excel(name = "公司编码")
    @ApiModelProperty(value = "公司编码")
    private String ownerCompanyCode;

    /**
     * 排列顺序
     */
    @Excel(name = "排列顺序")
    @ApiModelProperty(value = "排列顺序")
    private Integer modelOrderNo;

    /**
     * 提交人编号
     */
    @Excel(name = "提交人编号")
    @ApiModelProperty(value = "提交人编号")
    private String modelUserId;


    /**
     * 提交人姓名
     */
    @Excel(name = "提交人姓名")
    @ApiModelProperty(value = "提交人姓名")
    private String modelUserName;

    /**
     * 模型创建时间
     */
    @Excel(name = "创建时间")
    @ApiModelProperty(value = "创建时间")
    @TableField(value = "model_ctime")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelCtime;

    /**
     * 模型修改时间
     */
    @Excel(name = "修改时间")
    @ApiModelProperty(value = "修改时间")
    @TableField(value = "model_mtime")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelMtime;

    /**
     * 是否删除 0:未删除 1:已删除
     */
    @Excel(name = "是否删除", replace = {"未删除_1", "已删除_2"})
    @ApiModelProperty(value = "是否删除")
    private Integer boolDelete;

    /**
     * 所属区域 1:生成控制大区 2:信息关联大区 3:互联网大区
     */
    @Excel(name = "所属区域", replace = {"生成控制大区_1", "信息关联大区_2", "互联网大区_3"})
    @ApiModelProperty(value = "所属区域")
    private Integer modelZone;

    /**
     * 所属层级 1:应用层 2:平台层 3:网络层 4:感知层
     */
    @Excel(name = "方机构类型", replace = {"应用层_1", "平台层_2", "网络层_3", "感知层_4"})
    @ApiModelProperty(value = "所属层级 1:应用层 2:平台层3:网络层 4:感知层")
    private Integer modelLayer;

    /**
     * 模型版本（最新版本）
     */
    @Excel(name = "模型版本")
    @ApiModelProperty(value = "模型版本")
    private String modelVersion;

    /**
     * 建设厂商
     */
    @Excel(name = "建设厂商")
    @ApiModelProperty(value = "建设厂商")
    private String apiUnit;
}
