package com.pms.ocp.service.impl;


import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.common.constants.AnalysisConstant;
import com.pms.ocp.common.constants.ExportUtils;
import com.pms.ocp.mapper.OcpApiAuditMapper;
import com.pms.ocp.model.entity.OcpApiAudit;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.OcpApiAuditService;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Service
public class OcpApiAuditServiceImpl extends ServiceImpl<OcpApiAuditMapper,OcpApiAudit> implements OcpApiAuditService {

    @Autowired
    private OcpApiAuditMapper ocpApiAuditMapper;

    @Override
    public ResponseVO getOcpApiAuditList(OcpApiAudit ocpApiAudit) {
        List<OcpApiAudit> ocpApiAuditList = ocpApiAuditMapper.getOcpApiSubsList(ocpApiAudit);
        return ResponseVO.ok(ocpApiAuditList);
    }


    @Override
    public ResponseVO getOcpApiDetails(String objId) {
        OcpApiAudit ocpApiAudit = ocpApiAuditMapper.selectById(objId);
        return ResponseVO.ok(ocpApiAudit);
    }

    @Override
    public ResponseVO OaaById(OcpApiAudit ocpApiAudit) {
        List<OcpApiAudit> oaaById = ocpApiAuditMapper.OaaById(ocpApiAudit);
        return ResponseVO.ok(oaaById);
    }

    @Override
    public ResponseVO sById(OcpApiAudit ocpApiAudit) {
        List<OcpApiAudit> oaaById = ocpApiAuditMapper.sById(ocpApiAudit);
        return ResponseVO.ok(oaaById);
    }

    @Override
    public void exportExcel(OcpApiAudit ocpApiAudit, HttpServletRequest request, HttpServletResponse response) {
        List<OcpApiAudit> oaaById = ocpApiAuditMapper.OaaById(ocpApiAudit);
        ExportParams param = new ExportParams(AnalysisConstant.exportOcpApiAuditName.OCP_API_AUDIT,AnalysisConstant.exportOcpApiAuditName.OCP_API_AUDIT);
        Workbook workbook = ExcelExportUtil.exportExcel(param,OcpApiAudit.class,oaaById);
        ExportUtils.exportExcel(response, AnalysisConstant.exportOcpApiAuditName.OCP_API_AUDIT,workbook);
    }


}
