package com.pms.ocp.service.impl;



import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.common.utils.RandomStringUtils;
import com.pms.ocp.mapper.TenantBasicManagementMapper;
import com.pms.ocp.mapper.TenantMapper;
import com.pms.ocp.model.dto.*;
import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.service.TenantService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.sql.Timestamp;
import java.util.*;


@Service
public class TenantServiceImpl extends ServiceImpl<TenantMapper, OcpTenantGroup> implements TenantService {


    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private TenantBasicManagementMapper tenantBasicMapper;

    /**
     * 应用树分类管理
     *
     * @return
     */
    @Override
    public OcpTenantGroupDto getTree() {
        List<OcpTenantGroup> ocpTenantGroups = tenantMapper.selectList(null);

        //返回参数集合
        OcpTenantGroupDto ocpTenantGroupDto = new OcpTenantGroupDto();
        //顶级目录
        Set<String> stringSet = new HashSet<>();

        for (OcpTenantGroup ocpTenantGroup : ocpTenantGroups) {
            String tenantGroupCompanyCode = ocpTenantGroup.getTenantGroupCompanyCode();
            stringSet.add(tenantGroupCompanyCode);
        }

        List<TwoTenanList> tenanLists =  twoTenanTree(ocpTenantGroups,stringSet);
        List<ThreeTenanList> threeTenanLists = ThreeTenanTree(ocpTenantGroups,tenanLists);
        ocpTenantGroupDto.setOneList(stringSet);
        ocpTenantGroupDto.setTwoList(tenanLists);
        ocpTenantGroupDto.setThreeList(threeTenanLists);


        return ocpTenantGroupDto;
    }

    private List<ThreeTenanList> ThreeTenanTree(List<OcpTenantGroup> ocpTenantGroups, List<TwoTenanList> tenanLists) {
        //三级应用详情
        List<ThreeTenanList> threeTenanLists = new ArrayList<>();

        for (TwoTenanList tenanList : tenanLists) {
            for (OcpTenantGroup ocpTenantGroup : ocpTenantGroups) {
                ThreeTenanList threeTenanList = new ThreeTenanList();
                if (tenanList.getTenantGroupCode().equals(ocpTenantGroup.getTenantGroupPcode()) && ocpTenantGroup.getTenantGroupLevel() == 2){
                    BeanUtils.copyProperties(ocpTenantGroup,threeTenanList);
                    threeTenanLists.add(threeTenanList);
                }
            }
        }
        return threeTenanLists;
    }

    /**
     * 二级  应用管理
     * @param ocpTenantGroups
     * @param stringSet
     * @return
     */
    private List<TwoTenanList> twoTenanTree(List<OcpTenantGroup> ocpTenantGroups, Set<String> stringSet) {
        //一级数据集合
        List<TwoTenanList> twoTenanLists = new ArrayList<>();
        for (String code : stringSet) {
            for (OcpTenantGroup ocpTenantGroup : ocpTenantGroups) {
                TwoTenanList twoTenanList = new TwoTenanList();
                if (code.equals(ocpTenantGroup.getTenantGroupCompanyCode()) &&ocpTenantGroup.getTenantGroupLevel() == 1){
                    BeanUtils.copyProperties(ocpTenantGroup,twoTenanList);
                    twoTenanLists.add(twoTenanList);
                }
            }
        }
        return twoTenanLists;
    }


    /**
     * 应用新增
     *
     * @param
     * @return
     */
    @Override
    public boolean getTenanInster(TenanBaseDto tenanBaseDto) {
        boolean falg = true;

        OcpTenantGroup group = new OcpTenantGroup();
        String tenantGroupCode = tenanBaseDto.getTenantGroupCode();
        List<OcpTenantGroup> ocpTenantGroups = tenantMapper.selectList(null);
        for (OcpTenantGroup tenantGroup : ocpTenantGroups) {
            if (tenantGroup.getTenantGroupCode().equals(tenantGroupCode)){
                falg = false;
                break;
            }
        }
        String randomString = RandomStringUtils.getRandomString(6);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        OcpTenantGroup ocpTenantGroup = new OcpTenantGroup();
        BeanUtils.copyProperties(tenanBaseDto,ocpTenantGroup);
        if ("null".equals(tenanBaseDto.getOwnerCompanyCode())){
            ocpTenantGroup.setTenantGroupCode(randomString);
        }
        ocpTenantGroup.setTenantGroupCtime(timestamp);
        ocpTenantGroup.setTenantGroupMtime(timestamp);
        if ("".equals(tenanBaseDto.getTenantVersion())){
            ocpTenantGroup.setTenantGroupVersion("1.0");
        }

        OcpTenantBase ocpTenantBase = new OcpTenantBase();
        BeanUtils.copyProperties(tenanBaseDto,ocpTenantBase);
        if ("null".equals(tenanBaseDto.getTenantGroupCode())){
            group.setTenantGroupCode(randomString);
        }
        tenantMapper.insert(tenanBaseDto);
        tenantBasicMapper.insert(ocpTenantBase);
        return falg;
    }

    /**
     * 修改应用
     *
     * @param ocpTenantGroup
     * @return
     */
    @Override
    public boolean getTenantUpdata(OcpTenantGroup ocpTenantGroup) {
        boolean falg = true;
        List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectList(null);
        for (OcpTenantGroup ocpApiGroup : ocpTenantGroupList) {
            String code = ocpTenantGroup.getTenantGroupCode();
            if (code == ocpApiGroup.getTenantGroupCode()) {
                falg = false;
                break;
            }
        }
       tenantMapper.updateById(ocpTenantGroup);

        return falg;
    }

    /**
     * 删除服务
     *
     * @param ocpTenantGroup
     * @return
     */
    @Override
    public boolean gettenantDelete(OcpTenantGroup ocpTenantGroup) {
        String objId = ocpTenantGroup.getObjId();
        OcpTenantGroup ocpTenantGroup1 = tenantMapper.selectById(objId);
        boolean flag = true;
        List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectList(null);
        if (StringUtils.isBlank(ocpTenantGroup1.getTenantGroupPcode())) {
            for (OcpTenantGroup tenantGroup : ocpTenantGroupList) {
                String tenantGroupPcode = tenantGroup.getTenantGroupPcode();
                if ((ocpTenantGroup.getTenantGroupCode().equals(tenantGroupPcode))){
                    flag = false;
                    break;
                }
            }
        }

        tenantMapper.deleteById(objId);

        return flag;
    }

    /**
     * 应用分类--应用管理
     *
     * @param ocpTenantDto
     * @return
     */
    @Override
    public List<OcpTenantGroup> getsUse(PageOcpTenantDto ocpTenantDto) {

        LambdaQueryWrapper<OcpTenantGroup> qw = new LambdaQueryWrapper<>();
        qw.eq(OcpTenantGroup::getTenantGroupCompanyCode,ocpTenantDto.getTenantGroupCompanyCode());
        List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectList(qw);
        /*for (OcpTenantGroup ocpTenantGroup : ocpTenantGroupList) {
                if ("".equals(ocpTenantGroup.getTenantGroupPcode()) && ocpTenantDto.getTenantGroupCompanyCode().equals(ocpTenantGroup.getTenantGroupCompanyCode())
                && ocpTenantGroup.getTenantGroupLevel() == 1){
                    ocpTenantGroups.add(ocpTenantGroup);
            }
        }*/
        return ocpTenantGroupList;
    }

    /**
     * 应用分类--应用服务分页查
     * @param pageOcpTenantDto
     * @return
     */
    @Override
    public Page<OcpTenantGroup> getOnePages(PageOcpTenantDto pageOcpTenantDto) {
        Page<OcpTenantGroup> pageInfo;
        int pageSize = pageOcpTenantDto.getPageSize();
        int pageNum = pageOcpTenantDto.getPageNum();
        if (pageSize != 0 && pageNum != 0){
            pageInfo = new Page<>(pageSize,pageNum);
            List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectList(null);
            for (OcpTenantGroup ocpTenantGroup : ocpTenantGroupList) {
                if ("".equals(ocpTenantGroup.getTenantGroupPcode())){
                    continue;
                }
                if (pageOcpTenantDto.getTenantGroupCode().equals(ocpTenantGroup.getTenantGroupPcode())){
                    LambdaQueryWrapper<OcpTenantGroup> queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(OcpTenantGroup::getTenantGroupLevel,2);
                    queryWrapper.eq(OcpTenantGroup::getTenantGroupCompanyCode,ocpTenantGroup.getTenantGroupCompanyCode());
                    tenantMapper.selectPage(pageInfo,queryWrapper);
                }
            }
        }else {
            pageSize = 1;
            pageNum  = 5;
            pageInfo = new Page<>(pageSize,pageNum);
            List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectList(null);
            for (OcpTenantGroup ocpTenantGroup : ocpTenantGroupList) {
                if (ocpTenantGroup.getTenantGroupPcode().equals(pageOcpTenantDto.getTenantGroupCode())){
                    LambdaQueryWrapper<OcpTenantGroup> queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(OcpTenantGroup::getTenantGroupLevel,2);
                    tenantMapper.selectPage(pageInfo,queryWrapper);
                }
            }
        }
        return pageInfo;
    }

}
