package com.pms.ocp.biz;

import com.github.pagehelper.PageInfo;
import com.pms.ocp.model.dto.ModelPropertyVersionRequirementDTO;
import com.pms.ocp.model.dto.ModelVersionRequirementDTO;
import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.vo.ModelPropertyVersionRequirementVO;
import com.pms.ocp.model.vo.ModelVersionRequirementVO;

/**
 * @Auther: wangjian
 * @Date: 2022/4/1 10:29
 * @Description:
 */
public interface BizModelRequirementInfoService {

    /**
     * 创建模型需求
     *
     * @param modelVersionRequirementDTO
     * @return
     */
    Integer createModelRequirementInfo(ModelVersionRequirementDTO modelVersionRequirementDTO);


    /**
     * 创建模型属性
     *
     * @param modelPropertyVersionRequirementDTO
     * @return
     */
    Integer createModelPropertyRequirementInfo(ModelPropertyVersionRequirementDTO modelPropertyVersionRequirementDTO);

    /**
     * 修改模型需求
     *
     * @param modelVersionRequirementDTO
     * @return
     */
    Integer updateModelRequirementInfo(ModelVersionRequirementDTO modelVersionRequirementDTO);

    /**
     * 修改模型属性需求
     *
     * @param modelPropertyVersionRequirementDTO
     * @return
     */
    Integer updateModelPropertyRequirementInfo(ModelPropertyVersionRequirementDTO modelPropertyVersionRequirementDTO);

    /**
     * 删除模型需求
     *
     * @param objId
     * @param requirementCode
     * @param modelCode
     * @return
     */
    Integer deleteModelRequirementInfo(String objId, String requirementCode, String modelCode);

    /**
     * 删除模型属性需求
     *
     * @param requirementCode
     * @param modelCode
     * @param propCode
     * @return
     */
    Integer deleteModelPropertyRequirementInfo(String requirementCode, String modelCode, String propCode);

    /**
     * 获取模型需求
     *
     * @param
     * @return
     */
    PageInfo<ModelVersionRequirementVO> getModelRequirementInfoList(String modelName, String modelCode, String modelGroupCode, int currentPage, int pageSize);

    /**
     * 获取模型属性需求
     *
     * @param
     * @return
     */
    PageInfo<ModelPropertyVersionRequirementVO> getModelPropertyRequirementInfoList(String requirementCode, String modelCode, String columnName, int currentPage, int pageSize);

    /**
     * 获取模型需求
     *
     * @param objId
     * @param modelGroupCode
     * @return
     */
    Model getModelRequirementInfo(String objId, String modelGroupCode);

    /**
     * 获取模型属性需求
     *
     * @param objId
     * @param modelGroupCode
     * @return
     */
    Model getModelPropertyRequirementInfo(String objId, String modelGroupCode);

}
