package com.pms.ocp.biz.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.pms.ocp.biz.BizModelRequirementInfoService;
import com.pms.ocp.model.dto.ModelPropertyVersionRequirementDTO;
import com.pms.ocp.model.entity.*;
import com.pms.ocp.model.dto.ModelVersionRequirementDTO;
import com.pms.ocp.model.vo.ModelPropertyVersionRequirementVO;
import com.pms.ocp.model.vo.ModelVersionRequirementVO;
import com.pms.ocp.service.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/4/1 11:19
 * @Description:
 */

@Service
public class BizModelRequirementInfoServiceImpl implements BizModelRequirementInfoService {

    @Autowired
    private OcpModelGroupService ocpModelGroupService;

    @Autowired
    private ModelRequirementService modelRequirementService;

    @Autowired
    private ModelBaseVersionService modelBaseVersionService;

    @Autowired
    private ModelPropertyVersionService modelPropertyVersionService;

    @Autowired
    private ModelRequirementApprovalService modelRequirementApprovalService;

    @Transactional
    @Override
    public Integer createModelRequirementInfo(ModelVersionRequirementDTO modelVersionRequirementDTO) {

        /**
         * 根据时间戳生成唯一id
         */

        modelVersionRequirementDTO.setRequirementCode("MR-" + System.currentTimeMillis());

        // 需求信息创建
        ModelRequirement modelRequirement = new ModelRequirement();
        BeanUtils.copyProperties(modelVersionRequirementDTO, modelRequirement);
        modelRequirement.setCtime(LocalDateTime.now());
        modelRequirement.setRequirementCode(modelVersionRequirementDTO.getRequirementCode());

        // 需求审批信息创建
        ModelRequirementApproval modelRequirementApproval = new ModelRequirementApproval();
        modelRequirementApproval.setRequirementCode(modelVersionRequirementDTO.getRequirementCode());
        modelRequirementApproval.setApprovalStats(0);

        // 校验是否模型名称重复
        ModelBaseVersion modelBaseVersion1 = modelBaseVersionService.getModelBaseVersion(modelVersionRequirementDTO.getModelTable(), null, null);

        if (modelBaseVersion1 != null) {
            return -1;
        }

        // 表版本信息创建
        ModelBaseVersion modelBaseVersion = new ModelBaseVersion();
        BeanUtils.copyProperties(modelVersionRequirementDTO, modelBaseVersion);
        modelBaseVersion.setModelCtime(LocalDateTime.now());
        modelBaseVersion.setOwnerCompanyCode(modelVersionRequirementDTO.getCompanyCode());
        modelBaseVersion.setModelUserId(modelVersionRequirementDTO.getUserId());
        modelBaseVersion.setModelUserName(modelVersionRequirementDTO.getUserName());
        modelBaseVersion.setModelVersion((modelVersionRequirementDTO.getModelVersion() == null) ? "1" : String.valueOf(((Integer.valueOf(modelVersionRequirementDTO.getModelVersion()).intValue()) + 1)));

        modelRequirementService.createModelRequirement(modelRequirement);

        modelRequirementApprovalService.createModelRequirementApproval(modelRequirementApproval);

        modelBaseVersionService.createModelBaseVersion(modelBaseVersion);

        return 1;
    }

    @Transactional
    @Override
    public Integer createModelPropertyRequirementInfo(ModelPropertyVersionRequirementDTO modelPropertyVersionRequirementDTO) {

        ModelPropertyVersion modelPropertyVersion = new ModelPropertyVersion();
        BeanUtils.copyProperties(modelPropertyVersionRequirementDTO, modelPropertyVersion);
        modelPropertyVersion.setRequirementCode(modelPropertyVersionRequirementDTO.getRequirementCode());
        modelPropertyVersion.setModelCode(modelPropertyVersionRequirementDTO.getModelCode());

        modelPropertyVersion.setPropUserId(modelPropertyVersionRequirementDTO.getUserId());
        modelPropertyVersion.setPropUserName(modelPropertyVersionRequirementDTO.getUserName());

        modelPropertyVersion.setPropCtime(LocalDateTime.now());

        modelPropertyVersionService.createModelPropertyVersion(modelPropertyVersion);

        return 1;
    }

    @Transactional
    @Override
    public Integer updateModelRequirementInfo(ModelVersionRequirementDTO modelVersionRequirementDTO) {
        ModelRequirement modelRequirement = new ModelRequirement();
        BeanUtils.copyProperties(modelVersionRequirementDTO, modelRequirement);

        modelRequirement.setMtime(LocalDateTime.now());

        ModelBaseVersion modelBaseVersion = new ModelBaseVersion();
        BeanUtils.copyProperties(modelVersionRequirementDTO, modelBaseVersion);
        modelBaseVersion.setOwnerCompanyCode(modelVersionRequirementDTO.getCompanyCode());
        modelBaseVersion.setModelUserId(modelVersionRequirementDTO.getUserId());
        modelBaseVersion.setModelUserName(modelVersionRequirementDTO.getUserName());
        modelBaseVersion.setModelVersion((modelVersionRequirementDTO.getModelVersion() == null) ? "1" : String.valueOf(((Integer.valueOf(modelVersionRequirementDTO.getModelVersion()).intValue()) + 1)));

        modelRequirementService.updateModelRequirement(modelRequirement);

        modelBaseVersionService.updateModelBaseVersion(modelBaseVersion);

        return 1;
    }

    @Transactional
    @Override
    public Integer updateModelPropertyRequirementInfo(ModelPropertyVersionRequirementDTO modelPropertyVersionRequirementDTO) {

//        ModelRequirement modelRequirement = new ModelRequirement();
//        BeanUtils.copyProperties(modelPropertyVersionRequirementDTO, modelRequirement);
//        modelRequirement.setMtime(LocalDateTime.now());

        ModelPropertyVersion modelPropertyVersion = new ModelPropertyVersion();
        BeanUtils.copyProperties(modelPropertyVersionRequirementDTO, modelPropertyVersion);
        modelPropertyVersion.setPropMtime(LocalDateTime.now());
        modelPropertyVersion.setPropUserId(modelPropertyVersionRequirementDTO.getUserId());
        modelPropertyVersion.setPropUserName(modelPropertyVersionRequirementDTO.getUserName());
        modelPropertyVersion.setPropMtime(LocalDateTime.now());


        modelPropertyVersionService.updateModelPropertyVersion(modelPropertyVersion);


//        modelRequirementService.updateModelRequirement(modelRequirement);
        return 1;
    }

    @Transactional
    @Override
    public Integer deleteModelRequirementInfo(String objId, String requirementCode, String modelCode) {

        modelPropertyVersionService.deleteModelPropertyVersion(requirementCode, modelCode, null);
        modelBaseVersionService.deleteModelBaseVersion(requirementCode, modelCode);

        modelRequirementApprovalService.deleteModelRequirementApproval(null, requirementCode);
        modelRequirementService.deleteModelRequirement(objId, requirementCode);

        return 1;
    }

    @Transactional
    @Override
    public Integer deleteModelPropertyRequirementInfo(String requirementCode, String modelCode, String propCode) {

        modelPropertyVersionService.deleteModelPropertyVersion(requirementCode, modelCode, propCode);

        return 1;
    }

    @Override
    public Model getModelRequirementInfo(String objId, String modelGroupCode) {
        return null;
    }

    @Override
    public Model getModelPropertyRequirementInfo(String objId, String modelGroupCode) {
        return null;
    }

    @Override
    public PageInfo<ModelVersionRequirementVO> getModelRequirementInfoList(String modelName, String modelCode, String modelGroupCode, int currentPage, int pageSize) {

        List<String> modelGroupCodeList = new ArrayList<>();

        QueryWrapper<ModelClassify> queryWrapper = new QueryWrapper();
        List<ModelClassify> modelClassifyList = ocpModelGroupService.list(queryWrapper);

        getParentNode(modelGroupCodeList, modelClassifyList, modelGroupCode);
        modelGroupCodeList.add(modelGroupCode);

        PageHelper.startPage(currentPage, pageSize);
        List<ModelVersionRequirementVO> modelRequirementVOList = modelRequirementService.getModelRequirementList(modelName, modelCode, modelGroupCodeList);
        PageInfo<ModelVersionRequirementVO> pageInfo = new PageInfo<>(modelRequirementVOList);

        return pageInfo;
    }

    @Override
    public PageInfo<ModelPropertyVersionRequirementVO> getModelPropertyRequirementInfoList(String requirementCode, String modelCode, String columnName, int currentPage, int pageSize) {

        PageHelper.startPage(currentPage, pageSize);
        List<ModelPropertyVersionRequirementVO> modelPropertyVersionRequirementVOList = modelRequirementService.getModelPropertyRequirementList(requirementCode, modelCode, columnName);
        PageInfo<ModelPropertyVersionRequirementVO> pageInfo = new PageInfo<>(modelPropertyVersionRequirementVOList);

        return pageInfo;
    }

    /**
     * 递归获取某个父节点下面的所有子节点
     *
     * @param childMenu       要返回的结果
     * @param menuList        数据库查询出来的所有集合
     * @param modelGroupPcode 父类编码
     */
    private static void getParentNode(List<String> childMenu, List<ModelClassify> menuList, String modelGroupPcode) {
        menuList.stream()
                //过滤出父id等于参数的id
                .filter(menu -> StringUtils.isNotBlank(menu.getModelGroupPcode()) && menu.getModelGroupPcode().equals(modelGroupPcode))
                .forEach(menu -> {
                    //递归遍历下一级
                    getParentNode(childMenu, menuList, menu.getModelGroupCode());
                    //添加
                    childMenu.add(menu.getModelGroupCode());
                });
    }

}
