package com.pms.ocp.common.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * @author huxiuwu
 * @version 1.0
 * @date 2022/1/4 20:14
 */
public class DateUtils {
    private DateUtils() {
    }

    public static SimpleDateFormat sdf() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    /**
     * 获取当天的开始时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getDayBegin() {
        Calendar cal = new GregorianCalendar();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        return sdf().format(cal.getTime());
    }

    /**
     * 获取当天的结束时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getDayEnd() {
        Calendar cal = new GregorianCalendar();
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        return sdf().format(cal.getTime());
    }

    /**
     * 获取昨天的开始时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getBeginDayOfYesterday(Integer dayNum) {
        Calendar cal = new GregorianCalendar();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        cal.add(Calendar.DAY_OF_MONTH, dayNum);
        return sdf().format(cal.getTime());
    }

    /**
     * 获取昨天的结束时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getEndDayOfYesterday(Integer dayNum) {
        Calendar cal = new GregorianCalendar();
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        cal.add(Calendar.DAY_OF_MONTH,dayNum);
        return sdf().format(cal.getTime());
    }

    /**
     * 获得本周一0点时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getTimesWeekmorning() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(Calendar.DAY_OF_WEEK) - 1;
        if (day_of_week == 0)
            day_of_week = 7;
        c.add(Calendar.DATE, -day_of_week + 1);
        return format.format(c.getTime());
    }

    /**
     * 获得本周日24点时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getTimesWeeknight() {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(Calendar.DAY_OF_WEEK) - 1;
        if (day_of_week == 0)
            day_of_week = 7;
        c.add(Calendar.DATE, -day_of_week + 7);
        return formatDate.format(c.getTime());
    }

    /**
     * 根据当前日期获得最近n周的日期区间（不包含本周）
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getFromToDate(SimpleDateFormat sdf, Date date, int n, int option, int k) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK) - 1;
        int offset = 0 == option ? 1 - dayOfWeek : 7 - dayOfWeek;
        int amount = 0 == option ? offset - (n - 1 + k) * 7 : offset - k * 7;
        calendar.add(Calendar.DATE, amount);
        return sdf.format(calendar.getTime());
    }

    /**
     * 获取上周的开始时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getBeginDayOfLastWeek() {
        //上周日期
        SimpleDateFormat sdf = sdf();
        String beginDate = getFromToDate(sdf, new Date(), 1, 0, 1);

        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(sdf.parse(beginDate));
        } catch (Exception e) {
            e.printStackTrace();
        }
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return sdf.format(calendar.getTime());
    }


    /**
     * 获取上周的结束时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getEndDayOfLastWeek() {
        //上周日期
        SimpleDateFormat sdf = sdf();
        String endDate = getFromToDate(sdf, new Date(), 1, 1, 1);

        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(sdf.parse(endDate));
        } catch (Exception e) {
            e.printStackTrace();
        }
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        return sdf.format(calendar.getTime());
    }

    /**
     * 获得本月第一天0点时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getTimesMonthMorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(Calendar.YEAR), cal.get(Calendar.MONDAY), cal.get(Calendar.DAY_OF_MONTH), 0, 0, 0);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMinimum(Calendar.DAY_OF_MONTH));
        return sdf().format(cal.getTime());
    }

    /**
     * 获得本月最后一天24点时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getTimesMonthNight() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(Calendar.YEAR), cal.get(Calendar.MONDAY), cal.get(Calendar.DAY_OF_MONTH), 23, 59, 59);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        cal.set(Calendar.HOUR_OF_DAY, 23);
        return sdf().format(cal.getTime());
    }

    // 获得上月第一天0点时间

    /**
     * 获取昨天的开始时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getTimesLastMonthMorning(Integer last) {
        //上月日期
        Calendar c = Calendar.getInstance();
        c.add(Calendar.MONTH, last);
        int lastMonthMaxDay = c.getActualMaximum(Calendar.DAY_OF_MONTH);
        c.set(c.get(Calendar.YEAR), c.get(Calendar.MONTH), lastMonthMaxDay, 23, 59, 59);

        //按格式输出
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-01 00:00:00");
        String gTime = sdf2.format(c.getTime()); //上月第一天
        return gTime;
    }

    /**
     * 获得上月最后一天24点时间
     *
     * @author huxiuwu
     * @date 2022/1/4
     **/
    public static String getTimesLastMonthNight(Integer lastMonth) {
        //上月日期
        Calendar c = Calendar.getInstance();
        c.add(Calendar.MONTH, lastMonth);
        SimpleDateFormat sdf = sdf();
        int lastMonthMaxDay = c.getActualMaximum(Calendar.DAY_OF_MONTH);
        c.set(c.get(Calendar.YEAR), c.get(Calendar.MONTH), lastMonthMaxDay, 23, 59, 59);

        //按格式输出
        String g_time = sdf.format(c.getTime());
        return g_time;
    }


    public static Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    /**
     * 当前时间前后几个月
     *
     * @param month
     * @return
     */
    public static Timestamp getAssignMonthTime(Integer month) {
        return Timestamp.valueOf(LocalDateTime.now().plusMonths(month));
    }

    /**
     * 上一周
     *
     * @return
     */

    public static Timestamp getLaskWeek() {
        DateTime dateTime = DateUtil.lastWeek();
        return new Timestamp(dateTime.getTime());
    }

    /**
     * 获取月份 整数
     *
     * @param timestamp
     * @return
     */
    public static Integer getMonth(Timestamp timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        return calendar.get(Calendar.MONTH) + 1;
    }

    public static Timestamp getBeginTimeOfMonth(int year, int month) {
        YearMonth yearMonth = YearMonth.of(year, month);
        LocalDate localDate = yearMonth.atDay(1);
        LocalDateTime startOfDay = localDate.atStartOfDay();
        ZonedDateTime zonedDateTime = startOfDay.atZone(ZoneId.of("Asia/Shanghai"));
        Date from = Date.from(zonedDateTime.toInstant());
        return new Timestamp(from.getTime());
    }

    public static Timestamp getEndTimeOfMonth(int year, int month) {
        YearMonth yearMonth = YearMonth.of(year, month);
        LocalDate endOfMonth = yearMonth.atEndOfMonth();
        LocalDateTime localDateTime = endOfMonth.atTime(23, 59, 59, 999);
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.of("Asia/Shanghai"));
        Date from = Date.from(zonedDateTime.toInstant());
        return new Timestamp(from.getTime());
    }

    public static String getLastMonth() {
        LocalDate today = LocalDate.now();
        today = today.minusMonths(1);
        DateTimeFormatter formatters = DateTimeFormatter.ofPattern("yyyy-MM");
        return formatters.format(today);
    }

    public static String getYearAndMonth(Integer offset) {
        LocalDate today = LocalDate.now();
        today = today.minusMonths(offset);
        DateTimeFormatter formatters = DateTimeFormatter.ofPattern("yyyy-MM");
        return formatters.format(today);
    }
}
