package com.pms.ocp.common.utils;

import com.pms.ocp.model.vo.ResponseVO;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 工具类
 *
 * @author Administrator
 */
public class StringBusinessUtil {
    /**
     * 判断对象或数组中每一个对象是否为空
     * 判断对象是否为null
     * 判断字符串长度是否为0,集合类是否为empty
     *
     * @param obj
     * @return
     */
    public static boolean isNullOrEmpty(Object obj) {

        if (obj == null) {
            return true;
        }

        if (obj instanceof CharSequence) {
            return ((CharSequence) obj).length() == 0 || "null".equalsIgnoreCase(obj.toString());
        }

        if (obj instanceof Collection) {
            return ((Collection<?>) obj).isEmpty();
        }

        if (obj instanceof Map) {
            return ((Map<?, ?>) obj).isEmpty();
        }

        if (obj instanceof Object[]) {

            Object[] object = (Object[]) obj;
            if (object.length == 0) {
                return true;
            }

            boolean empty = true;
            for (int i = 0; i < object.length; i++) {
                if (!isNullOrEmpty(object[i])) {
                    empty = false;
                    break;
                }
            }
            return empty;
        }
        return false;
    }

    /**
     * 入参校验
     *
     * @param bindingResult
     * @return
     */
    public static ResponseVO verifyDispose(BindingResult bindingResult) {
        StringBuilder stringBuilder = new StringBuilder();
        List<ObjectError> allErrors = bindingResult.getAllErrors();
        for (ObjectError e : allErrors) {
            String defaultMessage = e.getDefaultMessage();
            if (!StringBusinessUtil.isNullOrEmpty(e.getDefaultMessage())) {
                stringBuilder.append(defaultMessage);
                stringBuilder.append(",");
            }
        }
        return ResponseVO.error(stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1));
    }
}
