package com.pms.ocp.controller;

import com.github.pagehelper.PageInfo;
import com.pms.ocp.common.utils.ExcelUtils;
import com.pms.ocp.common.utils.FileExport;
import com.pms.ocp.common.utils.FileUtil;
import com.pms.ocp.model.dto.ApiBaseDto;
import com.pms.ocp.model.dto.OcpGroupBaseDto;
import com.pms.ocp.model.entity.OcpApiBase;
import com.pms.ocp.model.entity.OcpApiGroup;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.model.vo.OcpApiBaseVo;
import com.pms.ocp.model.vo.ResponseVO;

import com.pms.ocp.service.ApiBasicManagementService;
import com.pms.ocp.service.ApiDetailsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author guofanfan
 */
@Slf4j
@RequestMapping("/api/basic")
@RestController
@Api(tags = "服务库服务基础管理接口")
public class ApiBasicManagementController {
    @Autowired
    private ApiDetailsService apiDetailsService;
    @Autowired
    private ApiBasicManagementService apiBasicManagementService;

    @ApiOperation("导入功能")
    @PostMapping("/import")
    public ResponseVO ApiImport(@RequestParam(required = false) MultipartFile file,
                                HttpServletRequest request) throws Exception {
        if (file == null) {
            return ResponseVO.ok("导入数据不能为空");
        }
        System.out.println(file);//用来检查前端是否把文件传过来
        //解析excel，
        List<OcpApiBaseVo> personList = FileUtil.importExcel(file, 0, 1, OcpApiBaseVo.class);
        System.out.println("导入数据一共【" + personList.size() + "】行");
        apiBasicManagementService.apiImport(personList);
        return ResponseVO.ok();
    }

    @ApiOperation("导出功能")
    @GetMapping("/export")
    public ResponseVO ApiExport(HttpServletResponse response,
                                @RequestParam(required = false) String apiCodes,
                                @RequestParam(required = false) String excelFileName) throws Exception {
        if (StringUtils.isEmpty(apiCodes)) {
            return ResponseVO.ok("请选择你要导出的数据");
        }
        List<OcpApiBaseVo> ocpApiBaseVoList = apiBasicManagementService.selectApiExport(apiCodes);

        if (StringUtils.isEmpty(excelFileName)) {
            excelFileName = "服务列表-";
        }

        //导出excel
        ExcelUtils.exportExcel(response, excelFileName + LocalDate.now(), ocpApiBaseVoList, OcpApiBaseVo.class);

        return ResponseVO.ok();
    }

    //        @ApiOperation("下载模板")
////    @GetMapping("/download")
//    @GetMapping(value = "/download", produces = "text/plain;charset=UTF-8")
//    public void ApiDownload(HttpServletResponse response) throws IOException {
//        String filePate = getClass().getResource("/template/233.xls").getPath();
//        InputStream bis = new BufferedInputStream(new FileInputStream(new File(filePate)));
//        //假如以中文名下载的话,设置下载文件名称
//        String filename = "导入模板.xls";
//        //转码,免得文件中文名中文乱码
//        filename = URLEncoder.encode(filename, "UTF-8");
//        //设置文件下载头
//        response.addHeader("Content-Disposition", "attachment;filename=" + filename);
////        response.setHeader("Content-Length",bis.available()+"");
//        //1.设置文件ContentType类型,这样设置.会自动判断下载文件类型
//        response.setContentType("multipart/form-data");
//        response.setCharacterEncoding("UTF-8");
////        response.setContentType("application/x-download");
//        BufferedOutputStream out = new BufferedOutputStream(response.getOutputStream());
//        int len = 0;
//        byte[] bytes = new byte[65536];
////        bytes=bytes.toString().getBytes("GBK");
//        while ((len = bis.read(bytes)) != -1) {
//            out.write(bytes,0,len);
//            out.flush();
//        }
//        out.close();
//
//    }
//@GetMapping("/downloadExcel")
//public void downloadExcel(HttpServletResponse response,HttpServletRequest request){
//        try {
//            String filename="233.xls";
//            String encoding = "UTF-8";
//            /** 获取浏览器相关的信息 */
//            String userAgent = request.getHeader("user-agent");
//            /** 判断是否为msie浏览器 */
//            if (userAgent.toLowerCase().indexOf("msie") != -1){
//                encoding = "gbk";
//            }
//            response.setHeader("Content-disposition", "attachment;filename=" + filename);
//            response.setContentType("application/vnd.ms-excel;charset=UTF-8");
//            String filePath = getClass().getResource("/template/" + filename).getPath();
//            FileInputStream input = new FileInputStream(filePath);
//            OutputStream outputStream = response.getOutputStream();
//            byte[] b = new byte[2048];
//            int len;
//            while ((len=input.read(b))!=-1){
//                outputStream.write(b,0,len);
//            }
//            response.setHeader("Content-Length",String.valueOf(input.getChannel().size()));
//            input.close();
//        }catch (Exception ex){
//            log.error("xx:",ex);
//        }
//}

    @ApiOperation("下载模块")
    @GetMapping("/downloadExcel")
    public void downloadExcel(HttpServletResponse response, HttpServletRequest request) {
        String[] excelHeader = {"序号", "服务编码", "服务中文名称", "所属集群", "所属命名空间", "接口URL", "状态", "注册时间", "建设单位"};
        List<Object> list = new ArrayList<>();
        FileExport.exportExcel(excelHeader, list, "XXX模板", response, request);
    }

    @ApiOperation("服务注册")
    @PostMapping("/add")
    public ResponseVO addOcpApiBase(@RequestBody OcpApiBase ocpApiBase) {
        apiBasicManagementService.addOcpApiBase(ocpApiBase);
        return ResponseVO.ok();
    }

    @ApiOperation("服务订阅")
    @GetMapping("/login")
    public ResponseVO ApiLogin(@RequestParam(required = false) String apiPromotion,
                               @RequestParam(required = false) String apiCodes) {
        if (StringUtils.isEmpty(apiPromotion)) {
            return ResponseVO.error("不能为空");
        } else if (apiPromotion.equals("0")) {
            return ResponseVO.error("统招");
        } else {
            apiBasicManagementService.apiLogin(apiCodes);
            return ResponseVO.ok();
        }

    }

    @ApiOperation("服务发布")
    @GetMapping("/issue")
    public ResponseVO ApiIssue(@RequestParam(required = false) String apiPromotion,
                               @RequestParam(required = false) String apiCodes) {
        if (StringUtils.isEmpty(apiPromotion)) {
            return ResponseVO.error("不能为空");
        } else if (apiPromotion.equals("0")) {
            return ResponseVO.error("统招");
        } else {
            return apiBasicManagementService.apiIssue(apiCodes);

        }

    }

    @ApiOperation("服务列表")
    @GetMapping("/apiListQuery")
    public ResponseVO<PageInfo<OcpApiBaseVo>> apiListQuery(HttpServletRequest request, ApiBaseDto ApiBaseReq) {

        return apiBasicManagementService.getBaseByGroupCode(ApiBaseReq);
    }

    @ApiOperation("服务分类层级")
    @GetMapping("/apiBaseTreeOther")
    public ResponseVO<List<OcpGroupBaseDto>> apiBaseTreeOther(String apiGroupCompanyCode, String apiGroupCode, Integer apiGroupPromotionType, String apiCode) {
        List<OcpGroupBaseDto> apiTreeGroupDtos = apiBasicManagementService.apiBaseTreeOther(apiGroupCompanyCode, apiGroupCode, apiGroupPromotionType, apiCode);
        return ResponseVO.ok(apiTreeGroupDtos);
    }

    @ApiOperation("服务树列表")
    @GetMapping("/apiBaseTreeList")
    public ResponseVO<List<OcpApiBase>> apiBaseTreeList(String apiGroupCompanyCode, String apiGroupCode) {
        List<OcpApiBase> apiBaseList = apiBasicManagementService.apiBaseTreeApiList(apiGroupCompanyCode, apiGroupCode);
        return ResponseVO.ok(apiBaseList);
    }

    @ApiOperation("省侧-应用接入申请-的模糊查询")
    @GetMapping("/selectByCondition")
    public ResponseVO<PageInfo<OcpApiBase>> selectByCondition(ApiBaseDto apiBaseReq) {
        return apiBasicManagementService.selectByCondition(apiBaseReq);

    }

    @ApiOperation("省侧-应用接入申请-查询组中所有中心")
    @GetMapping("/selectCentre")
    public ResponseVO<List<OcpApiGroup>> selectCentre() {
        return apiBasicManagementService.selectCentre();
    }

}
