package com.pms.ocp.controller;

import com.pms.ocp.common.utils.ExcelUtils;
import com.pms.ocp.common.utils.FileUtil;
import com.pms.ocp.model.dto.ApiManagementDto;
import com.pms.ocp.model.vo.ApiManagementVO;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ApiManagementService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.List;

/**
 * @className: ApiManagementController
 * @Description:
 * @author: pei-chen-xi
 * @DateTime: 2022/3/25 14:28
 */
@Slf4j
@RequestMapping("/api-management/v1")
@RestController
@Api(tags = "服务管理接口")
public class ApiManagementController {

    @Autowired
    private ApiManagementService apiManagementService;

    @ApiOperation(value = "服务管理查询")
    @GetMapping("/get/management")
    public ResponseVO getManagement(@RequestParam(required = false) String apiName,
                                                           @RequestParam(required = false) String apiGroupCode,
                                                           @RequestParam(required = false) String apiUrl,
                                                           @RequestParam(required = false) Timestamp startTime,
                                                           @RequestParam(required = false) Timestamp endTime,
                                                           @RequestParam(required = false) Integer pageSize,
                                                           @RequestParam(required = false) Integer pageNum

    ) {

        List<ApiManagementVO> list=apiManagementService.queryManagement(apiName,apiGroupCode,apiUrl,startTime,endTime,pageSize
                , pageNum);

        return ResponseVO.ok(list);
    }

    @ApiOperation(value = "服务管理新增")
    @PostMapping("/insert/management")
    public ResponseVO insertManagement(@RequestBody ApiManagementDto apiManagementDto){
        apiManagementService.insertManagement(apiManagementDto);
        return ResponseVO.ok();
    }

    @ApiOperation(value = "服务管理修改")
    @PostMapping("/update/management")
    public ResponseVO updateManagement(@RequestBody ApiManagementDto apiManagementDto){
        apiManagementService.updateManagement(apiManagementDto);
        return ResponseVO.ok();
    }

    @ApiOperation(value = "服务管理删除")
    @DeleteMapping("/delete/management")
    public ResponseVO deleteManagement(@RequestBody Integer ids){
        apiManagementService.deleteManagement(ids);
        return ResponseVO.ok();
    }

    @ApiOperation(value = "导入功能")
    @PostMapping("/import")
    public ResponseVO ApiImport(@RequestParam(required = false) MultipartFile file,
                                HttpServletRequest request) throws Exception{
        if (file == null){
            return ResponseVO.ok("导入数据不能为空");
        }
        System.out.println(file);//用来检查前端是否把文件传过来
        //解析excel,
        List<ApiManagementVO> personList = FileUtil.importExcel(file,0,1,ApiManagementVO.class);
        System.out.println("导入数据一共【" + personList.size() + "】行");
        apiManagementService.apiImport(personList);
        return ResponseVO.ok();
    }

    @ApiOperation("导出功能")
    @GetMapping("/export")
    public ResponseVO ApiExport(HttpServletResponse response,
                                @RequestParam(required = false) String apiCodes,
                                @RequestParam(required = false) String excelFileName) throws Exception {
        if (StringUtils.isEmpty(apiCodes)) {
            return ResponseVO.ok("请选择你要导出的数据");
        }
        List<ApiManagementVO> apiManagement = apiManagementService.selectApiExport(apiCodes);

        if (StringUtils.isEmpty(excelFileName)) {
            excelFileName = "服务列表-";
        }

        //导出excel
        ExcelUtils.exportExcel(response, excelFileName + LocalDate.now(), apiManagement, ApiManagementVO.class);

        return ResponseVO.ok();
    }
}
