package com.pms.ocp.controller;

import com.pms.ocp.model.vo.CatalogVO;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.CatalogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @className: CatalogController
 * @Description:
 * @author: pei-chen-xi
 * @DateTime: 2022/3/27 13:36
 */
@Slf4j
@RequestMapping("/catalog/v1")
@RestController
@Api(tags = "服务目录接口")
public class CatalogController {

    @Autowired
    private CatalogService catalogService;

    @ApiOperation(value = "服务目录查询")
    @GetMapping("/get/catalog")
    public ResponseVO getCatalog(CatalogVO catalogVO){

        List<CatalogVO> list=catalogService.getCatalog(catalogVO);

        return ResponseVO.ok(list);

    }
}
