package com.pms.ocp.controller;

import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.entity.ModelPropInfo;
import com.pms.ocp.model.vo.ModelAcceptVo;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ModelAcceptService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author huxiuwu
 * @version 1.0
 * @date 2022/4/7 15:56
 */
@Slf4j
@RequestMapping("/modelAccept")
@RestController
@Api(tags = "模型管控-模型验收")
public class ModelAcceptController {

    @Autowired
    private ModelAcceptService modelAcceptService;

    /**
     * 模型验收列表
     * @author huxiuwu
     * @date 2022/4/7
     * @return pms.ocp.model.vo.ResponseVO
     **/
    @ApiOperation("模型验收列表")
    @GetMapping("/modelAcceptList")
    public ResponseVO modelAuditList() {
        return modelAcceptService.modelAcceptList();
    }

    /**
     * 模型验收详情
     * @author huxiuwu
     * @date 2022/4/8
     * @param modelCode 模型编码
     * @param requirementCode 需求编码
     * @return pms.ocp.model.vo.ResponseVO
     **/
    @ApiOperation("模型验收详情")
    @GetMapping("/modelAuditDetail")
    public ResponseVO<ModelAcceptVo> modelAuditDetail(@ApiParam(value = "需求编码") @RequestParam(value = "modelCode") String modelCode,
                                                      @ApiParam(value = "模型编码") @RequestParam(value = "requirementCode") String requirementCode) {
        return modelAcceptService.modelAuditDetail(modelCode,requirementCode);
    }

    /**
     * 模型信息对比
     * @author huxiuwu
     * @date 2022/4/11
     * @param requirementCode 需求编码
     * @param modelCode 模型编码
     * @param tableName 表名称
     * @return ResponseVO<java.util.List<com.pms.ocp.model.entity.ModelPropInfo>>
     **/
    @ApiOperation("模型信息对比")
    @GetMapping("/modelDetailCompare")
    public ResponseVO<List<ModelPropInfo>> modelDetailCompare(@ApiParam(value = "需求编码") @RequestParam(value = "requirementCode") String requirementCode,
                                                              @ApiParam(value = "模型编码") @RequestParam(value = "modelCode") String modelCode,
                                                              @ApiParam(value = "表名称") @RequestParam(value = "tableName") String tableName) {
        return modelAcceptService.modelDetailCompare(requirementCode,modelCode,tableName);
    }

    /**
     *
     * @author huxiuwu
     * @date 2022/4/11
     * @param model 模型数据
     * @return ResponseVO<java.util.List<com.pms.ocp.model.entity.ModelPropInfo>>
     **/
    @ApiOperation("验收通过")
    @PostMapping("/modelAcceptPass")
    public ResponseVO<List<ModelPropInfo>> modelAcceptPass(@RequestBody Model model) {
        return modelAcceptService.modelAcceptPass(model);
    }

}
