package com.pms.ocp.controller;

import com.github.pagehelper.PageInfo;
import com.pms.ocp.model.dto.ModelAuditDto;
import com.pms.ocp.model.entity.ModelPropInfo;
import com.pms.ocp.model.vo.ModelCheckVo;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ModelCheckService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author huxiuwu
 * @version 1.0
 * @date 2022/4/6 10:07
 * 模型审核
 */
@Slf4j
@RequestMapping("/modelAudit")
@RestController
@Api(tags = "模型管控-模型审核")
public class ModelCheckController {

    @Autowired
    private ModelCheckService modelCheckService;

    /**
     * 模型审核列表
     * @author huxiuwu
     * @date 2022/4/6
     * @param currentPage 当前页
     * @param pageSize 每页数量
     * @param searchCondition 搜索条件
     * @return ResponseVO<java.util.List<com.pms.ocp.model.vo.ModelCheckVo>>
     **/
    @ApiOperation("模型审核列表")
    @GetMapping("/modelAuditList")
    public ResponseVO<PageInfo<ModelCheckVo>> modelAuditList(@ApiParam(value = "当前页") @RequestParam(value = "currentPage", required = false,defaultValue = "1") Integer currentPage,
                                                             @ApiParam(value = "每页数量") @RequestParam(value = "pageSize", required = false,defaultValue = "10") Integer pageSize,
                                                             @ApiParam(value = "搜索条件") @RequestParam(value = "searchCondition", required = false) String searchCondition) {

        return modelCheckService.modelAuditList(currentPage,pageSize,searchCondition);
    }

    /**
     * 修改审核状态
     * @author huxiuwu
     * @date 2022/4/6
     * @param ocp
     * @return pms.ocp.model.vo.ResponseVO
     **/
    @ApiOperation("修改审核状态")
    @PostMapping("/updateAuditType")
    public ResponseVO updateAuditType (@RequestBody ModelAuditDto ocp){
        return modelCheckService.updateAuditType(ocp);
    }

    /**
     * 模型关系表
     * @author huxiuwu
     * @date 2022/4/7
     * @param modelCode
     * @return pms.ocp.model.vo.ResponseVO
     **/
    @ApiOperation("模型关系")
    @GetMapping("/modelRelation")
    public ResponseVO<List<ModelPropInfo>> modelRelation (@ApiParam(value = "模型编码") @RequestParam(value = "modelCode")String modelCode){
        return modelCheckService.modelRelation(modelCode);
    }

}
