package com.pms.ocp.controller;

import com.pms.ocp.biz.BizModelRequirementInfoService;
import com.pms.ocp.common.constants.CodeEnum;
import com.pms.ocp.model.dto.ModelPropertyVersionRequirementDTO;
import com.pms.ocp.model.dto.ModelRequirementDeleteParamDTO;
import com.pms.ocp.model.dto.ModelVersionRequirementDTO;
import com.pms.ocp.model.vo.ResponseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Auther: wangjian
 * @Date: 2022/3/29 17:18
 * @Description:模型库管理管控需求接口
 */

@ControllerAdvice
@Slf4j
@RequestMapping("/model-control/v1")
@RestController
@Api(tags = "模型库管理管控需求接口")
public class ModelControlDemandController {

    @Autowired
    private BizModelRequirementInfoService bizModelRequirementInfoService;

    /**
     * 模型需求-增加
     *
     * @return
     */
    @ApiOperation("模型需求-增加")
    @PostMapping("/create/modelRequirement")
    public ResponseVO createModelRequirement(@RequestBody ModelVersionRequirementDTO modelVersionRequirementDTO) {

        Integer integer = bizModelRequirementInfoService.createModelRequirementInfo(modelVersionRequirementDTO);

        if (integer.equals(-1)) {
            return ResponseVO.ok(CodeEnum.MODEL_NAME_REPETITION.getDesc());
        }

        return ResponseVO.ok(integer);
    }

    /**
     * 模型属性需求-增加
     *
     * @return
     */
    @ApiOperation("模型属性需求-增加")
    @PostMapping("/create/modelPropertyRequirement")
    public ResponseVO createModelPropertyRequirement(@RequestBody ModelPropertyVersionRequirementDTO modelPropertyVersionRequirementDTO) {

        return ResponseVO.ok(bizModelRequirementInfoService.createModelPropertyRequirementInfo(modelPropertyVersionRequirementDTO));
    }

    /**
     * 模型需求-删除
     *
     * @return
     */
    @ApiOperation("模型需求-删除")
    @PostMapping("/delete/modelRequirement")
    public ResponseVO deleteModelRequirement(@RequestBody ModelRequirementDeleteParamDTO modelRequirementDeleteParamDTO) {

        String requirementCode = modelRequirementDeleteParamDTO.getRequirementCode();
        String modelCode = modelRequirementDeleteParamDTO.getModelCode();
//        String propCode = modelRequirementDeleteParamDTO.getPropCode();
        String objId = modelRequirementDeleteParamDTO.getObjId();

        log.info("需求编码为：{}", requirementCode);
        return ResponseVO.ok(bizModelRequirementInfoService.deleteModelRequirementInfo(objId, requirementCode, modelCode));
    }

    /**
     * 模型属性需求-删除
     *
     * @return
     */
    @ApiOperation("模型属性需求-删除")
    @PostMapping("/delete/modelPropertyRequirement")
    public ResponseVO deleteModelPropertyRequirement(@RequestBody ModelRequirementDeleteParamDTO modelRequirementDeleteParamDTO) {

        String requirementCode = modelRequirementDeleteParamDTO.getRequirementCode();
        String modelCode = modelRequirementDeleteParamDTO.getModelCode();
        String propCode = modelRequirementDeleteParamDTO.getPropCode();

        return ResponseVO.ok(bizModelRequirementInfoService.deleteModelPropertyRequirementInfo(requirementCode, modelCode, propCode));
    }

    /**
     * 模型需求-修改
     *
     * @return
     */
    @ApiOperation("模型需求-修改")
    @PostMapping("/update/modelRequirement")
    public ResponseVO updateModelRequirement(@RequestBody ModelVersionRequirementDTO modelVersionRequirementDTO) {
        return ResponseVO.ok(bizModelRequirementInfoService.updateModelRequirementInfo(modelVersionRequirementDTO));
    }

    /**
     * 模型属性需求-修改
     *
     * @return
     */
    @ApiOperation("模型属性需求-修改")
    @PostMapping("/update/modelPropertyRequirement")
    public ResponseVO updateModelPropertyRequirement(@RequestBody ModelPropertyVersionRequirementDTO modelPropertyVersionRequirementDTO) {
        return ResponseVO.ok(bizModelRequirementInfoService.updateModelPropertyRequirementInfo(modelPropertyVersionRequirementDTO));
    }

    /**
     * 模型需求-查询列表
     *
     * @return
     */
    @ApiOperation("模型需求-查询列表")
    @GetMapping("/get/modelRequirement/list")
    public ResponseVO getModelRequirementList(@ApiParam(value = "模型编码") @RequestParam(value = "modelCode", required = false) String modelCode,
                                              @ApiParam(value = "模型名称") @RequestParam(value = "modelName", required = false) String modelName,
                                              @ApiParam(value = "模型分类编码") @RequestParam(value = "modelGroupCode", required = false) String modelGroupCode,
                                              @ApiParam(value = "当前页") @RequestParam(value = "currentPage") Integer currentPage,
                                              @ApiParam(value = "每页数量") @RequestParam(value = "pageSize") Integer pageSize) {
        return ResponseVO.ok(bizModelRequirementInfoService.getModelRequirementInfoList(modelName, modelCode, modelGroupCode, currentPage, pageSize));

    }

    /**
     * 模型属性需求-查询列表
     *
     * @return
     */
    @ApiOperation("模型属性需求-查询列表")
    @GetMapping("/get/modelPropertyRequirement/list")
    public ResponseVO getModelPropertyDemandList(@ApiParam(value = "需求编码") @RequestParam(value = "requirementCode", required = false) String requirementCode,
                                                 @ApiParam(value = "模型编码") @RequestParam(value = "modelCode", required = false) String modelCode,
                                                 @ApiParam(value = "属性名称") @RequestParam(value = "columnName", required = false) String columnName,
                                                 @ApiParam(value = "当前页") @RequestParam(value = "currentPage") Integer currentPage,
                                                 @ApiParam(value = "每页数量") @RequestParam(value = "pageSize") Integer pageSize) {
        return ResponseVO.ok(bizModelRequirementInfoService.getModelPropertyRequirementInfoList(requirementCode, modelCode, columnName, currentPage, pageSize));

    }

    /**
     * 模型属性需求-查询列表
     *
     * @return
     */
    @ApiOperation("模型需求-查询服务支撑")
    @GetMapping("/get/modelRequirement/serviceSupport/list")
    public ResponseVO getModelDemandServiceSupportList(@ApiParam(value = "需求编码") @RequestParam(value = "requirementCode", required = false) String requirementCode,
                                                       @ApiParam(value = "模型编码") @RequestParam(value = "modelCode", required = false) String modelCode,
                                                       @ApiParam(value = "当前页") @RequestParam(value = "currentPage") Integer currentPage,
                                                       @ApiParam(value = "每页数量") @RequestParam(value = "pageSize") Integer pageSize) {
        return ResponseVO.ok(bizModelRequirementInfoService.getModelPropertyRequirementInfoList(requirementCode, modelCode, null, currentPage, pageSize));

    }


}
