package com.pms.ocp.controller;


import com.github.pagehelper.PageInfo;
import com.pms.ocp.model.ResponseResult;
import com.pms.ocp.model.dto.ApiBaseDto;
import com.pms.ocp.model.entity.*;
import com.pms.ocp.model.vo.OcpApiBaseVo;
import com.pms.ocp.model.vo.OcpApiGroupVo;
import com.pms.ocp.model.vo.OcpModelGroupVO;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


@Slf4j
@RequestMapping("/api")
@RestController
@Api(tags = "服务接口")
public class PmsApiDetailsController {
    @Autowired
    private ApiBasicManagementService apiBasicManagementService;

    @Autowired
    private PmsApiSubsService pmsApiSubsService;

    @Autowired
    private PmsApiAuditService pmsApiAuditService;

    @Autowired
    private PmsApiTenantRelService pmsApiTenantRelService;

    @Autowired
    private PmsApiModelRelService pmsApiModelRelService;

    @Autowired
    private PmsApiManagementService pmsApiManagementService;

    @Autowired
    private OcpApiTreeService service;


    @ApiOperation("服务订阅记录-查询")
    @PostMapping("/getocpapisublist")
    public ResponseVO<List<PmsApiSubs>> getOcpApiSubsList(PmsApiSubs pmsApiSubs) {
        return pmsApiSubsService.getPmsApiSubsList(pmsApiSubs);
    }

    @ApiOperation("服务大事记-查询")
    @PostMapping("/getocpapiauditlist")
    public ResponseVO<List<PmsApiAudit>> getPmsApiAuditList(PmsApiAudit pmsApiAudit) {
        return pmsApiAuditService.getOcpApiAuditList(pmsApiAudit);
    }

//    @ApiOperation("服务大事记-查询详情")
//    @PostMapping("/getocpapidetails")
//    public ResponseVO<List<OcpApiAudit>> getOcpApiDetails(@RequestBody OcpApiAudit ocpApiAudit){
//        return ocpApiAuditService.sById(ocpApiAudit);
//    }

    @ApiOperation("服务大事记-查询详情-变更内容")
    @PostMapping("/getocpapi")
    public ResponseVO<List<PmsApiAudit>> getOcpApi(@RequestBody PmsApiAudit pmsApiAudit){
        return pmsApiAuditService.OaaById(pmsApiAudit);
    }

    @ApiOperation("服务大事记-历史版本")
    @PostMapping("/versionid")
    public ResponseVO<List<PmsApiAudit>> versionId(@RequestBody PmsApiAudit pmsApiAudit){
        return pmsApiAuditService.versionId(pmsApiAudit);
    }

    @ApiOperation("服务与应用拓扑图-查询")
    @PostMapping("/getoatrlist")
    public ResponseVO<List<PmsApiTenantRel>> getOatrList(@RequestBody PmsApiTenantRel pmsApiTenantRel) {
        return pmsApiTenantRelService.getOatrList(pmsApiTenantRel);
    }

    @ApiOperation("服务与模型拓扑图-查询")
    @PostMapping("/getoamrlist")
    public ResponseVO<List<PmsApiModelRel>> getOamrList(@RequestBody PmsApiModelRel pmsApiModelRel) {
        return pmsApiModelRelService.getOamrList(pmsApiModelRel);
    }

    @ApiOperation("服务大事记-导出")
    @PostMapping("/export")
    public void exportExcel(@RequestBody PmsApiAudit pmsApiAudit, HttpServletRequest request, HttpServletResponse response) {
        pmsApiAuditService.exportExcel(pmsApiAudit,request,response);
    }

    @ApiOperation("服务分类")
    @GetMapping("province/provinceList")
    public ResponseVO<PageInfo<OcpApiBaseVo>> getPamm(ApiBaseDto apiBaseReq) {
        return apiBasicManagementService.getBaseByGroupCode(apiBaseReq);
    }

    @ApiOperation("服务分类——详情")
    @PostMapping("/getPammByCode")
    public ResponseVO<List<PmsApiManagement>> getPammByCode(@RequestBody PmsApiManagement pmsApiManagement) {
        return pmsApiManagementService.getPammByCode(pmsApiManagement);
    }


    @ApiOperation("服务分类——添加服务")
    @PostMapping("/add")
    public ResponseVO add(@RequestBody  PmsApiMangageApi pmsApiMangageApi) {
        PmsApiMangageApi pmsApiMangageApi1 = pmsApiManagementService.add(pmsApiMangageApi);
        if (StringUtils.isBlank(pmsApiMangageApi1.getObjId())){
            return ResponseVO.error("id已存在");
        }else {
            return ResponseVO.ok(pmsApiMangageApi1);
        }
    }


    @ApiOperation("服务分类——删除服务")
    @PostMapping("/delete")
    public ResponseVO delete(@RequestBody  PmsApiMangageApi pmsApiMangageApi) {
        ResponseResult responseResult = pmsApiManagementService.deleteApi(pmsApiMangageApi);
       return ResponseVO.ok(responseResult.getMessage());
    }

    @ApiOperation("服务分类——编辑服务")
    @PostMapping("/update")
    public ResponseVO update(@RequestBody  PmsApiMangageApi pmsApiMangageApi) {
        PmsApiMangageApi pmsApiMangageApi1 = pmsApiManagementService.updateApi(pmsApiMangageApi);
        if (pmsApiMangageApi1.getBoole()){
            return ResponseVO.ok(pmsApiMangageApi1);
        }else {
            return ResponseVO.error("修改失败");

        }

    }

    @ApiOperation("模型分类导航")
    @GetMapping("/navigation")
    public ResponseVO<List<OcpApiGroupVo>> getApiNavigation() {
        return pmsApiManagementService.getApiNavigation();
    }


}
