package com.pms.ocp.mapper;

import com.pms.ocp.model.dto.ModelAuditDto;
import com.pms.ocp.model.dto.OcpModelRequirementAcceptDto;
import com.pms.ocp.model.entity.ModelPropInfo;
import com.pms.ocp.model.vo.ModelCheckVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author huxiuwu
 * @version 1.0
 * @date 2022/4/6 10:13
 */
@Mapper
public interface ModelCheckMapper {

    List<ModelCheckVo> modelAuditList(@Param("searchCondition") String searchCondition);

    List<ModelCheckVo> selectCompanyList();

    boolean updateAuditState(ModelAuditDto ocp);

    boolean saveAccept(OcpModelRequirementAcceptDto ocp);

    List<ModelPropInfo> selectModelOwnerProp();

    List<String> selectModelCodeList(@Param("modelCode") String modelCode);

    void deleteByRequirementCode(ModelAuditDto ocp);

}
