package com.pms.ocp.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.pms.ocp.model.entity.ModelRelation;
import com.pms.ocp.model.vo.ModelRelationInputMultiVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:25
 * @Description:模型关系数据层接口
 */

@Mapper
public interface ModelRelationMapper extends BaseMapper<ModelRelation> {


    /**
     * 根据id查询区域信息
     *
     * @param modelCode
     * @return 区域信息列表
     */
    ModelRelation queryRegionById(@Param("modelCode") String modelCode);

    /**
     * 根据regionId列表，查询区域信息
     *
     * @param regionInputMultiVO 区域id列表
     * @return 区域信息列表
     */
    List<ModelRelation> queryRegionByRegionIdList(ModelRelationInputMultiVO regionInputMultiVO);

    /**
     * 根据parentId查询区域信息
     *
     * @param modelCode 区域id
     * @return 区域信息列表
     */
    List<ModelRelation> queryRegionByParentId(@Param("modelCode") String modelCode);

}
