package com.pms.ocp.model.dto;

import com.pms.ocp.common.config.CreateGroups;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 应用注册入参实体
 *
 * @author Administrator
 */
@ApiModel(value = "应用注册入参实体")
@Data
public class AppRegisterDTO {

    @ApiModelProperty("用户id")
    @NotBlank(message = "用户id不能为空", groups = CreateGroups.class)
    private String userId;

    @ApiModelProperty("用户名称")
    @NotBlank(message = "用户名称不能为空", groups = CreateGroups.class)
    private String userName;


    @ApiModelProperty("应用图标")
//    @NotBlank(message = "应用图标不能为空", groups = CreateGroups.class)
    private byte[] imgUrl;

    @ApiModelProperty("应用名称")
    @NotBlank(message = "应用名称不能为空", groups = CreateGroups.class)
    private String appName;

    @ApiModelProperty("应用编码")
    @NotBlank(message = "应用编码不能为空", groups = CreateGroups.class)
    private String appCode;

    @ApiModelProperty("所属专业——ts:输电,t:变电,dc:直流,ds配电,tc:技术,pl计划,im综合")
    @NotBlank(message = "所属专业不能为空", groups = CreateGroups.class)
    private String kind;


//    @ApiModelProperty("所属中心")
//    @NotBlank(message = "所属中心不能为空", groups = CreateGroups.class)
//    private String center;

    @ApiModelProperty("所属类别——基础管理,分析决策,作业管理,设备管理")
    @NotBlank(message = "所属类别不能为空", groups = CreateGroups.class)
    private String type;

    @ApiModelProperty("应用描述")
    @NotBlank(message = "应用描述不能为空", groups = CreateGroups.class)
    private String desc;

    @ApiModelProperty("开发厂商")
    @NotBlank(message = "开发厂商不能为空", groups = CreateGroups.class)
    private String manufacturer;

    @ApiModelProperty("当前版本")
    @NotBlank(message = "当前版本不能为空", groups = CreateGroups.class)
    private String version;

    @ApiModelProperty("所属集群")
    @NotBlank(message = "所属集群不能为空", groups = CreateGroups.class)
    private String group;

    @ApiModelProperty("部署名称")
    @NotBlank(message = "部署名称不能为空", groups = CreateGroups.class)
    private String deploymentName;

    @ApiModelProperty("注册时间")
    private Date time;

    @ApiModelProperty("url")
    private String url;

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppCode() {
        return appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public String getKind() {
        return kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

//    public String getCenter() {
//        return center;
//    }
//
//    public void setCenter(String center) {
//        this.center = center;
//    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDeploymentName() {
        return deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public byte[] getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(byte[] imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }


}
