package com.pms.ocp.model.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * @Auther: wangjian
 * @Date: 2022/3/29 17:27
 * @Description:模型需求传输对象
 */

@ApiModel("模型需求传输对象")
@Data
public class ModelVersionRequirementDTO {

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 模型编码
     */
    @ApiModelProperty(value = "模型编码")
    private String modelCode;

    /**
     * 模型名称
     */
    @ApiModelProperty(value = "模型名称")
    private String modelName;

    /**
     * 模型表名称
     */
    @ApiModelProperty(value = "模型表名称")
    private String modelTable;

    /**
     * 需求编码
     */
    @ApiModelProperty(value = "需求编码")
    private String requirementCode;

    /**
     * 设备类型
     */
    @ApiModelProperty(value = "设备类型")
    private String equipType;

    /**
     * 所属专业 ts:输电, t:变电, dc:直流, ds配电, tc:技术, pl:计划, im:综合
     */
    @ApiModelProperty(value = "所属专业 ts:输电, t:变电, dc:直流, ds配电, tc:技术, pl:计划, im:综合")
    private String professionalKind;

    /**
     * 模型分类编码
     */
    @ApiModelProperty(value = "模型分类编码")
    private String modelGroupCode;

    /**
     * 公司编码
     */
//    @ApiModelProperty(value = "公司编码")
//    private String ownerCompanyCode;

    /**
     * 提交人id
     */
//    @ApiModelProperty(value = "提交人id")
//    private String modelUserId;

    /**
     * 提交人姓名
     */
//    @ApiModelProperty(value = "提交人姓名")
//    private String modelUserName;

    /**
     * 排列顺序
     */
    @ApiModelProperty(value = "排列顺序")
    private Integer modelOrderNo;


    /**
     * 创建时间
     */
//    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
//    @ApiModelProperty(value = "创建时间")
//    private LocalDateTime modelCtime;

    /**
     * 修改时间
     */
//    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
//    @ApiModelProperty(value = "修改时间")
//    private LocalDateTime modelMtime;

    /**
     * 所属区域 1:生成控制大区 2:信息关联大区3:互联网大区
     */
    @ApiModelProperty(value = "所属区域 1:生成控制大区 2:信息关联大区 3:互联网大区")
    private Integer modelZone;

    /**
     * 所属层级 1:应用层 2:平台层3:网络层 4:感知层
     */
    @ApiModelProperty(value = "所属层级 1:应用层, 2:平台层, 3:网络层, 4:感知层")
    private Integer modelLayer;

    /**
     * 模型版本号
     */
    @ApiModelProperty(value = "模型版本号")
    private String modelVersion;

    /**
     * 设计厂商
     */
    @ApiModelProperty(value = "设计厂商")
    private String apiUnit;

    /**
     * 版本简述
     */
    @ApiModelProperty(value = "版本简述")
    private String modelVersionDesc;

    /**
     * 是否已经删除 0未删除, 1已删除
     */
    @ApiModelProperty(value = "是否已经删除 0未删除, 1已删除")
    @TableField("is_delete")
    private Integer boolDelete;

    /**
     * 需求类型 0:新增，1:迭代，2下线
     */
    @ApiModelProperty(value = "需求类型 0:新增，1:迭代，2下线")
    private Integer requirementType;

    /**
     * 需求简述
     */
    @ApiModelProperty(value = "需求简述")
    private String requirementDesc;

    /**
     * 需求提报公司
     */
    @ApiModelProperty(value = "需求提报公司")
    private String companyCode;

    /**
     * 提交人id
     */
    @ApiModelProperty(value = "提交人id")
    private String userId;

    /**
     * 提交人姓名
     */
    @ApiModelProperty(value = "提交人姓名")
    private String userName;

    /**
     * 创建时间
     */
//    @ApiModelProperty(value = "创建时间")
//    private LocalDateTime ctime;

    /**
     * 修改时间
     */
//    @ApiModelProperty(value = "修改时间")
//    private LocalDateTime mtime;

    /**
     * 需求审核状态0:未通过1:通过
     */
    @ApiModelProperty(value = "需求审核状态 0:未通过, 1:通过")
    private Integer requirementStatus;

    /**
     * 推广类型 0:统推, 1：自建
     */
    @ApiModelProperty(value = "推广类型 0:统推, 1：自建")
    private Integer modelPromotion;

}


//    字段名称	字段描述	字段类型	允许为NULL	备注
//        demand_id	主键	varchar(42)	否
//        model_id	模型编号	varchar(42)	否
//        prop_id	属性编号	varchar(42)	是
//        demand_version	版本	varchar(10)	是
//        company_id	省公司ID	varchar(42)	是
//        company_name	省公司名称	varchar(50)	是
//        apply_user_id	提交人id	varchar(42)	否
//        apply_user_name	提交人姓名	varchar(64)	否
//        apply_ctime	创建时间	timestamp(6)	否
//        flow_type	流程类型	int4	否	0:新增,1:迭代
//        flow_message	需求描述	varchar(1000)	是
//        flow_statu	需求审核状态	int4	是	0:不同意, 1：同意
//        flow_comment	审核意见	varchar(100)	是
//        flow_user_id	审核人id	"varchar(42)	"	是
//        flow_user_name	审核人姓名	varchar(64)	是
//        flow_mtime	审核时间	timestamp(6)	是


//  "applyUserId": "",
//          "applyUserName": "",
//          "companyId": "",
//          "companyName": "",
//          "demandVersion": "",
//          "flowComment": "",
//          "flowMessage": "",
//          "flowStatu": 0,
//          "flowType": 0,
//          "flowUserId": "",
//          "flowUserName": "",
//          "model_code": "",
//          "model_name": "",
//          "model_table": ""
