package com.pms.ocp.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 模型需求验收表(OcpModelRequirementAcceptDto)实体类
 *
 * @author huxiuwu
 * @since 2022-04-06 17:18:51
 */
@Data
public class OcpModelRequirementAcceptDto implements Serializable {
    private static final long serialVersionUID = -44873798104620306L; 
   
    /**
    * 主键　
    */
    @ApiModelProperty(value = "主键")
    private String objId;
    /**
    * 需求编码　
    */
    @ApiModelProperty(value = "需求编码　")
    private String requirementCode;
    /**
    * 服务编码
    */
    @ApiModelProperty(value = "服务编码")
    private String apiCode;
    /**
    * 验收状态0:未验收 1：验收通过 2：验收拒绝
    */
    @ApiModelProperty(value = "验收状态0:未验收 1：验收通过 2：验收拒绝")
    private Integer acceptStats;
    /**
    * 验收单位　
    */
    @ApiModelProperty(value = "验收单位")
    private String acceptCompanyCode;
    /**
    * 验收部门　
    */
    @ApiModelProperty(value = "验收部门")
    private String acceptDepartment;
    /**
    * 验收人　
    */
    @ApiModelProperty(value = "验收人")
    private String acceptUserId;
    /**
    * 验收人姓名　
    */
    @ApiModelProperty(value = "验收人姓名")
    private String acceptUserName;
    /**
    * 验收时间　
    */
    @ApiModelProperty(value = "验收时间　")
    private Date acceptCtime;
    /**
    * 修改时间　
    */
    @ApiModelProperty(value = "修改时间")
    private Date acceptMtime;
    /**
    * 是否删除0：否 1：是
    */
    @ApiModelProperty(value = "是否删除0：否 1：是")
    private Integer isDelete;

}
 
 


