package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:52
 * @Description:模型事记记录对象
 */

@Data
@TableName("ocp_model_audit")
public class ModelAudit {

    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 模型代码
     */
    private int modelCode;

    /**
     * 属性代码
     */
    private int propCode;


    /**
     * 事记类型 0:人工操作,1:流程管控,3:总部下发
     */
    private int auditType;

    /**
     * 模型异动详情
     */
    private String auditMessageJson;

    /**
     * 异动类型 0:新增,1:迭代
     */
    private int operStatus;

    /**
     * 异动申请人id
     */
    private String applyUserId;

    /**
     * 异动申请人姓名
     */
    private String applyUserName;

    /**
     * 异动时间
     */
    private long applyTime;

    /**
     * 版本
     */
    private String applyVersion;

    /**
     * 新增时间
     */
    private LocalDateTime auditCtime;

    /**
     * 异动公司编号
     */
    private String auditCompanyCode;

    /**
     * 提交人id
     */
    private String auditUserId;

    /**
     * 提交人姓名
     */
    private String auditUserName;

    /**
     * 修改时间
     */
    private LocalDateTime auditMtime;

}

//
//    COMMENT ON COLUMN public.ocp_model_audit.obj_id IS '主键是';
//        COMMENT ON COLUMN public.ocp_model_audit.model_code IS '模型代码是';
//        COMMENT ON COLUMN public.ocp_model_audit.prop_code IS '属性代码';
//        COMMENT ON COLUMN public.ocp_model_audit.oper_status IS '异动类型0:新增,1:迭代';
//        COMMENT ON COLUMN public.ocp_model_audit.oper_target IS '操作对象0:表，1:属性';
//        COMMENT ON COLUMN public.ocp_model_audit.audit_type IS '事记类型0:人工操作,1:流程管控,3:总部下发';
//        COMMENT ON COLUMN public.ocp_model_audit.audit_message_json IS '模型异动详情';
//        COMMENT ON COLUMN public.ocp_model_audit.apply_user_id IS '异动申请人id';
//        COMMENT ON COLUMN public.ocp_model_audit.apply_user_name IS '异动申请人';
//        COMMENT ON COLUMN public.ocp_model_audit.apply_time IS '异动时间';
//        COMMENT ON COLUMN public.ocp_model_audit.audit_ctime IS '申请时间';
//        COMMENT ON COLUMN public.ocp_model_audit.audit_mtime IS '修改时间';
//        COMMENT ON COLUMN public.ocp_model_audit.apply_version IS '版本';
//        COMMENT ON COLUMN public.ocp_model_audit.audit_company_code IS '异动公司code';
//        COMMENT ON COLUMN public.ocp_model_audit.audit_user_id IS '提交人id';
//        COMMENT ON COLUMN public.ocp_model_audit.audit_user_name IS '提交人姓名';
