package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/3/30 17:17
 * @Description:模型基础信息版本表对象
 */

@Data
@TableName("ocp_model_version")
public class ModelBaseVersion {

    /**
     * 主键
     */
    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 模型名称
     */
    private String modelName;

    /**
     * 模型编码
     */
    private String modelCode;

    /**
     * 需求编码
     */
    private String requirementCode;

    /**
     * 设备类型
     */
    private String equipType;

    /**
     * 所属专业 ts:输电,t:变电, dc:直流，ds配电，tc:技术，pl计划 im综合
     */
    private String professionalKind;

    /**
     * 模型分类编码
     */
    private String modelGroupCode;

    /**
     * 模型表(表的英文名称)表的英文名称
     */
    private String modelTable;

    /**
     * 公司编码
     */
    private String ownerCompanyCode;

    /**
     * 排列顺序
     */
    private Integer modelOrderNo;

    /**
     * 提交人id
     */
    private String modelUserId;

    /**
     * 提交人姓名
     */
    private String modelUserName;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelCtime;

    /**
     * 修改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelMtime;

    /**
     * 所属区域 1:生成控制大区 2:信息关联大区3:互联网大区
     */
    private Integer modelZone;

    /**
     * 所属层级 1:应用层 2:平台层3:网络层 4:感知层
     */
    private Integer modelLayer;

    /**
     * 模型版本号
     */
    private String modelVersion;

    /**
     * 推广类型 0:统推, 1：自建
     */
    private Integer modelPromotion;

    /**
     * 设计厂商
     */
    private String apiUnit;

    /**
     * 版本简述
     */
    private String modelVersionDesc;

    /**
     * 是否已经删除 0未删除  1已删除
     */
    @TableField("is_delete")
    private Integer boolDelete;

}


//    CREATE TABLE operating_platform.ocp_model_version (
//        obj_id varchar(42) NOT NULL ,
//        model_name varchar(50) NOT NULL ,
//        model_code varchar(42) NOT NULL ,
//        requirement_code varchar(42) NOT NULL ,
//        equip_type varchar(42) ,
//        professional_kind varchar(10) ,
//        model_group_code varchar(42) ,
//        model_table varchar(50) ,
//        owner_company_code varchar(42) NOT NULL ,
//        model_order_no int4 ,
//        model_user_id varchar(42) ,
//        model_user_name varchar(64) ,
//        model_ctime timestamp(6) ,
//        model_mtime timestamp(6) ,
//        model_zone int2 ,
//        model_layer int2 ,
//        model_version varchar(10) ,
//        api_unit varchar(50) ,
//        model_version_desc varchar(200) ,
//        is_delete Int ,
//        PRIMARY KEY (obj_id)
//        )
//        ;
//
//        COMMENT ON COLUMN operating_platform.ocp_model_version.obj_id IS '主键';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_name IS '模型名称';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_code IS '模型编码';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.requirement_code IS '需求编号';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.equip_type IS '设备类型';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.professional_kind IS '所属专业ts:输电,t:变电, dc:直流，ds配电，tc:技术，pl计划 im综合';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_group_code IS '模型分类编码';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_table IS '模型表(表的英文名称)表的英文名称';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.owner_company_code IS '公司code';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_order_no IS '排列顺序';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_user_id IS '提交人id';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_user_name IS '提交人姓名';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_ctime IS '创建时间';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_mtime IS '修改时间';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_zone IS '所属区域1:生成控制大区 2:信息关联大区3:互联网大区';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_layer IS '所属层级1:应用层 2:平台层3:网络层 4:感知层';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_version IS '模型版本号';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.api_unit IS '设计厂商';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.model_version_desc IS '版本简述';
//        COMMENT ON COLUMN operating_platform.ocp_model_version.is_delete IS '是否已经删除0未删除  1已删除';
//
//        COMMENT ON TABLE operating_platform.ocp_model_version IS '模型版本信息表';
