package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/3/30 17:26
 * @Description:模型属性版本表对象
 */

@Data
@TableName("ocp_model_prop_version")
public class ModelPropertyVersion {

    /**
     * 主键
     */
    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 模型编码
     */
    private String modelCode;

    /**
     * 属性名称
     */
    private String columnName;

    /**
     * 模型版本号
     */
    private String modelVersion;

    /**
     * 属性编码
     */
    private String propCode;


    /**
     * 属性描述
     */
    private String columnComments;

    /**
     * 数据类型
     */
    private String dataType;

    /**
     * 数据长度
     */
    private Integer dataLength;

    /**
     * 数据精度
     */
    private Integer dataScale;

    /**
     * 推广类型 0:统推, 1：自建
     */
    private Integer propPromotion;

    /**
     * 是否主键 0:否,1:是
     */
    @TableField("is_pk")
    private Integer boolPk;

    /**
     * 是否必填 0:否,1:是
     */
    @TableField("is_required")
    private Integer boolRequired;

    /**
     * 显示顺序
     */
    private Integer propOrderNo;

    /**
     * 提交人id
     */
    private String propUserId;

    /**
     * 提交人姓名
     */
    private String propUserName;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime propCtime;

    /**
     * 修改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime propMtime;

    /**
     * 需求编码
     */
    private String requirementCode;

    /**
     * 属性需求类型
     */
    private Integer propRequirementType;


    /**
     * 属性需求描述
     */
    private String propRequirementDesc;


}

//        CREATE TABLE operating_platform.ocp_model_prop_version (
//        obj_id varchar(42) NOT NULL ,
//        model_code varchar(42) NOT NULL ,
//        column_name varchar(50) NOT NULL ,
//        model_version varchar(10) ,
//        prop_code varchar(42) NOT NULL ,
//        column_comments varchar(50) ,
//        data_type varchar(30) ,
//        data_length int4 ,
//        data_scale int4 ,
//        is_pk int4 ,
//        is_required int4 ,
//        prop_order_no int4 ,
//        prop_user_id varchar(42) ,
//        prop_user_name varchar(64) ,
//        prop_ctime timestamp(6) ,
//        prop_mtime timestamp(6) ,
//        PRIMARY KEY (obj_id)
//        )
//        ;
//
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.obj_id IS '主键';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.model_code IS '模型code';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.column_name IS '属性名称';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.model_version IS '模型版本号';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.prop_code IS '属性编码';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.column_comments IS '属性描述';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.data_type IS '数据类型';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.data_length IS '数据长度';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.data_scale IS '数据精度';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.is_pk IS '是否主键0:否,1:是';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.is_required IS '是否必填0:否,1:是';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.prop_order_no IS '显示顺序';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.prop_user_id IS '提交人id';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.prop_user_name IS '提交人姓名';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.prop_ctime IS '创建时间';
//        COMMENT ON COLUMN operating_platform.ocp_model_prop_version.prop_mtime IS '修改时间';
//
//        COMMENT ON TABLE operating_platform.ocp_model_prop_version IS '模型版本属性表';
