package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.models.auth.In;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/3/29 17:27
 * @Description:模型需求表对象
 */

@Data
@TableName("ocp_model_requirement")
public class ModelRequirement {

    /**
     * 主键
     */
    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 需求编码
     */
    private String requirementCode;

    /**
     * 需求类型 0:新增，1:迭代，2下线
     */
    private Integer requirementType;

    /**
     * 需求简述
     */
    private String requirementDesc;

    /**
     * 需求提报公司
     */
    private String companyCode;

    /**
     * 提交人id
     */
    private String userId;

    /**
     * 提交人姓名
     */
    private String userName;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime ctime;

    /**
     * 修改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime mtime;

    /**
     * 需求审核状态0:未通过1:通过
     */
    private Integer requirementStatus;
}


//        CREATE TABLE operating_platform.ocp_model_requirement (
//        obj_id varchar(42) NOT NULL ,
//        requirement_code varchar(42) NOT NULL ,
//        requirement_type int2 NOT NULL ,
//        requirement_desc varchar(200) NOT NULL ,
//        company_code varchar(42) NOT NULL ,
//        user_id varchar(42) ,
//        user_name varchar(64) ,
//        ctime timestamp(6) NOT NULL ,
//        mtime timestamp(6) NOT NULL ,
//        requirement_statu Int2 ,
//        PRIMARY KEY (obj_id)
//        )
//        ;
//
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement.obj_id IS '主键';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement.requirement_code IS '需求编码';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement.requirement_type IS '需求类型0:新增，1:迭代，2下线';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement.requirement_desc IS '需求简述';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement.company_code IS '需求提报公司';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement.user_id IS '提交人id';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement.user_name IS '提交人姓名';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement.ctime IS '创建时间';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement.mtime IS '修改时间 ';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement.requirement_statu IS '需求审核状态0:未通过1:通过 ';
//
//        COMMENT ON TABLE operating_platform.ocp_model_requirement IS '模型需求表';
