package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/4/7 11:17
 * @Description:模型需求审批表对象
 */

@Data
@TableName("ocp_model_requirement_approval")
public class ModelRequirementApproval {

    /**
     * 主键
     */
    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 需求编码
     */
    private String requirementCode;

    /**
     * 审批状态 0:未审核 1：审核通过 2：审核拒绝
     */
    private Integer approvalStats;

    /**
     * 审核人单位
     */
    private String approvalCompanyCode;

    /**
     * 审核人部门
     */
    private String approvalDepartment;

    /**
     * 审核人id
     */
    private String approvalUserId;

    /**
     * 审核人姓名
     */
    private String approvalUserName;

    /**
     * 审核时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime approvalCtime;

    /**
     * 修改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime approvalMtime;

    /**
     * 是否删除 0：否 1：是
     */
    @TableField("is_delete")
    private Integer boolDelete;

    /**
     * 审核意见
     */
    private String approvalComment;

}


//    DROP TABLE IF EXISTS operating_platform.ocp_model_requirement_approval;
//        CREATE TABLE operating_platform.ocp_model_requirement_approval (
//        obj_id varchar(42) NOT NULL ,
//        requirement_code varchar(42) NOT NULL ,
//        approval_stats Int2 NOT NULL ,
//        approval_company_code varchar(42) NOT NULL ,
//        approval_department varchar(42) NOT NULL ,
//        approval_user_id varchar(42) NOT NULL ,
//        approval_user_name varchar(64) NOT NULL ,
//        approval_ctime timestamp(6) NOT NULL ,
//        approval_mtime timestamp(6) ,
//        is_delete int2 NOT NULL ,
//        approval_comment varchar(500) NOT NULL ,
//        PRIMARY KEY (obj_id)
//        )
//        ;
//
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement_approval.obj_id IS '主键　';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement_approval.requirement_code IS '需求编码　';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement_approval.approval_stats IS '审批状态0:未审核 1：审核通过 2：审核拒绝';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement_approval.approval_company_code IS '审核人单位　';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement_approval.approval_department IS '审核人部门　';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement_approval.approval_user_id IS '审核人id　';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement_approval.approval_user_name IS '审核人姓名　';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement_approval.approval_ctime IS '审核时间　';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement_approval.approval_mtime IS '修改时间　';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement_approval.is_delete IS '是否删除0：否 1：是';
//        COMMENT ON COLUMN operating_platform.ocp_model_requirement_approval.approval_comment IS '审核意见　';
//
//        COMMENT ON TABLE operating_platform.ocp_model_requirement_approval IS '模型需求审批表';