package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;


/**
 * 应用分类表
 *
 * @TableName ocp_tenant_group
 */
@Data
@Accessors(chain = true)
@TableName("ocp_tenant_group")
@ApiModel("应用分类表1")
public class OcpTenantGroup implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键")
    private String objId;

    /**
     * 应用分类编码
     */
    @ApiModelProperty("应用分类编码")
    private String tenantGroupCode;

    /**
     * 应用分类名称
     */
    @ApiModelProperty("应用分类名称")
    private String tenantGroupName;

    /**
     * 分类创建公司
     */
    @ApiModelProperty("分类创建公司")
    private String tenantGroupCompanyCode;

    /**
     * 上级code
     */
    @ApiModelProperty("上级code")
    private String tenantGroupPcode;

    /**
     * 应用类别设备级、生态级等
     */
    @ApiModelProperty("应用类别设备级、生态级等")
    private String tenantType;

    /**
     * 分类版本
     */
    @ApiModelProperty("分类版本")
    private String tenantGroupVersion;

    /**
     * 显示顺序
     */
    @ApiModelProperty("显示顺序")
    private Integer tenantGroupOrderNo;

    /**
     * 提交人id
     */
    @ApiModelProperty("提交人id")
    private String tenantGroupUserId;

    /**
     * 提交人姓名
     */
    @ApiModelProperty("提交人姓名")
    private String tenantGroupUserName;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Timestamp tenantGroupCtime;

    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Timestamp tenantGroupMtime;

    /**
     * 是否删除
     */
    @ApiModelProperty("是否删除")
    private Short isDelete;

    /**
     * 应用树层级 1:应用分组层  2:应用层
     */
    @ApiModelProperty("应用树层级 1:应用分组层  2:应用层")
    private String tenantGroupLevel;

    //上级分类名称

    @ApiModelProperty("上级分类名称")
    @TableField(exist = false)
    private String classIfy;

    @ApiModelProperty("分类等级")
    @TableField(exist = false)
    private String level;
    @ApiModelProperty("查询等级")
    @TableField(exist = false)
    private String lev;

    @ApiModelProperty("判断是否新增成功")
    @TableField(exist = false)
    private String num;

    @ApiModelProperty("模糊查询字段")
    @TableField(exist = false)
    private String keyword;

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getClassIfy() {
        return classIfy;
    }

    public void setClassIfy(String classIfy) {
        this.classIfy = classIfy;
    }

    public String getLev() {
        return level;
    }

    public void setLev(String lev) {
        this.level = level;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    public String getObjId() {
        return objId;
    }

    /**
     * 主键
     */
    public void setObjId(String objId) {
        this.objId = objId;
    }

    /**
     * 应用分类编码
     */
    public String getTenantGroupCode() {
        return tenantGroupCode;
    }

    /**
     * 应用分类编码
     */
    public void setTenantGroupCode(String tenantGroupCode) {
        this.tenantGroupCode = tenantGroupCode;
    }

    /**
     * 应用分类名称
     */
    public String getTenantGroupName() {
        return tenantGroupName;
    }

    /**
     * 应用分类名称
     */
    public void setTenantGroupName(String tenantGroupName) {
        this.tenantGroupName = tenantGroupName;
    }

    /**
     * 分类创建公司
     */
    public String getTenantGroupCompanyCode() {
        return tenantGroupCompanyCode;
    }

    /**
     * 分类创建公司
     */
    public void setTenantGroupCompanyCode(String tenantGroupCompanyCode) {
        this.tenantGroupCompanyCode = tenantGroupCompanyCode;
    }

    /**
     * 上级code
     */
    public String getTenantGroupPcode() {
        return tenantGroupPcode;
    }

    /**
     * 上级code
     */
    public void setTenantGroupPcode(String tenantGroupPcode) {
        this.tenantGroupPcode = tenantGroupPcode;
    }

    /**
     * 应用类别设备级、生态级等
     */
    public String getTenantType() {
        return tenantType;
    }

    /**
     * 应用类别设备级、生态级等
     */
    public void setTenantType(String tenantType) {
        this.tenantType = tenantType;
    }

    /**
     * 分类版本
     */
    public String getTenantGroupVersion() {
        return tenantGroupVersion;
    }

    /**
     * 分类版本
     */
    public void setTenantGroupVersion(String tenantGroupVersion) {
        this.tenantGroupVersion = tenantGroupVersion;
    }

    /**
     * 显示顺序
     */
    public Integer getTenantGroupOrderNo() {
        return tenantGroupOrderNo;
    }

    /**
     * 显示顺序
     */
    public void setTenantGroupOrderNo(Integer tenantGroupOrderNo) {
        this.tenantGroupOrderNo = tenantGroupOrderNo;
    }

    /**
     * 提交人id
     */
    public String getTenantGroupUserId() {
        return tenantGroupUserId;
    }

    /**
     * 提交人id
     */
    public void setTenantGroupUserId(String tenantGroupUserId) {
        this.tenantGroupUserId = tenantGroupUserId;
    }

    /**
     * 提交人姓名
     */
    public String getTenantGroupUserName() {
        return tenantGroupUserName;
    }

    /**
     * 提交人姓名
     */
    public void setTenantGroupUserName(String tenantGroupUserName) {
        this.tenantGroupUserName = tenantGroupUserName;
    }

    /**
     * 创建时间
     */
    public Date getTenantGroupCtime() {
        return tenantGroupCtime;
    }

    /**
     * 创建时间
     */
    public void setTenantGroupCtime(Timestamp tenantGroupCtime) {
        this.tenantGroupCtime = tenantGroupCtime;
    }

    /**
     * 修改时间
     */
    public Date getTenantGroupMtime() {
        return tenantGroupMtime;
    }

    /**
     * 修改时间
     */
    public void setTenantGroupMtime(Timestamp tenantGroupMtime) {
        this.tenantGroupMtime = tenantGroupMtime;
    }

    /**
     * 是否删除
     */
    public Short getIsDelete() {
        return isDelete;
    }

    /**
     * 是否删除
     */
    public void setIsDelete(Short isDelete) {
        this.isDelete = isDelete;
    }

//    /**
//     * 应用树层级 1:应用分组层  2:应用层
//     */
//    public Short getTenantGroupLevel() {
//        return tenantGroupLevel;
//    }
//
//    /**
//     * 应用树层级 1:应用分组层  2:应用层
//     */
//    public void setTenantGroupLevel(Short tenantGroupLevel) {
//        this.tenantGroupLevel = tenantGroupLevel;
//    }

    public String getTenantGroupLevel() {
        return tenantGroupLevel;
    }

    public void setTenantGroupLevel(String tenantGroupLevel) {
        this.tenantGroupLevel = tenantGroupLevel;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        OcpTenantGroup other = (OcpTenantGroup) that;
        return (this.getObjId() == null ? other.getObjId() == null : this.getObjId().equals(other.getObjId()))
                && (this.getTenantGroupCode() == null ? other.getTenantGroupCode() == null : this.getTenantGroupCode().equals(other.getTenantGroupCode()))
                && (this.getTenantGroupName() == null ? other.getTenantGroupName() == null : this.getTenantGroupName().equals(other.getTenantGroupName()))
                && (this.getTenantGroupCompanyCode() == null ? other.getTenantGroupCompanyCode() == null : this.getTenantGroupCompanyCode().equals(other.getTenantGroupCompanyCode()))
                && (this.getTenantGroupPcode() == null ? other.getTenantGroupPcode() == null : this.getTenantGroupPcode().equals(other.getTenantGroupPcode()))
                && (this.getTenantType() == null ? other.getTenantType() == null : this.getTenantType().equals(other.getTenantType()))
                && (this.getTenantGroupVersion() == null ? other.getTenantGroupVersion() == null : this.getTenantGroupVersion().equals(other.getTenantGroupVersion()))
                && (this.getTenantGroupOrderNo() == null ? other.getTenantGroupOrderNo() == null : this.getTenantGroupOrderNo().equals(other.getTenantGroupOrderNo()))
                && (this.getTenantGroupUserId() == null ? other.getTenantGroupUserId() == null : this.getTenantGroupUserId().equals(other.getTenantGroupUserId()))
                && (this.getTenantGroupUserName() == null ? other.getTenantGroupUserName() == null : this.getTenantGroupUserName().equals(other.getTenantGroupUserName()))
                && (this.getTenantGroupCtime() == null ? other.getTenantGroupCtime() == null : this.getTenantGroupCtime().equals(other.getTenantGroupCtime()))
                && (this.getTenantGroupMtime() == null ? other.getTenantGroupMtime() == null : this.getTenantGroupMtime().equals(other.getTenantGroupMtime()))
                && (this.getIsDelete() == null ? other.getIsDelete() == null : this.getIsDelete().equals(other.getIsDelete()))
                && (this.getTenantGroupLevel() == null ? other.getTenantGroupLevel() == null : this.getTenantGroupLevel().equals(other.getTenantGroupLevel()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getObjId() == null) ? 0 : getObjId().hashCode());
        result = prime * result + ((getTenantGroupCode() == null) ? 0 : getTenantGroupCode().hashCode());
        result = prime * result + ((getTenantGroupName() == null) ? 0 : getTenantGroupName().hashCode());
        result = prime * result + ((getTenantGroupCompanyCode() == null) ? 0 : getTenantGroupCompanyCode().hashCode());
        result = prime * result + ((getTenantGroupPcode() == null) ? 0 : getTenantGroupPcode().hashCode());
        result = prime * result + ((getTenantType() == null) ? 0 : getTenantType().hashCode());
        result = prime * result + ((getTenantGroupVersion() == null) ? 0 : getTenantGroupVersion().hashCode());
        result = prime * result + ((getTenantGroupOrderNo() == null) ? 0 : getTenantGroupOrderNo().hashCode());
        result = prime * result + ((getTenantGroupUserId() == null) ? 0 : getTenantGroupUserId().hashCode());
        result = prime * result + ((getTenantGroupUserName() == null) ? 0 : getTenantGroupUserName().hashCode());
        result = prime * result + ((getTenantGroupCtime() == null) ? 0 : getTenantGroupCtime().hashCode());
        result = prime * result + ((getTenantGroupMtime() == null) ? 0 : getTenantGroupMtime().hashCode());
        result = prime * result + ((getIsDelete() == null) ? 0 : getIsDelete().hashCode());
        result = prime * result + ((getTenantGroupLevel() == null) ? 0 : getTenantGroupLevel().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", objId=").append(objId);
        sb.append(", tenantGroupCode=").append(tenantGroupCode);
        sb.append(", tenantGroupName=").append(tenantGroupName);
        sb.append(", tenantGroupCompanyCode=").append(tenantGroupCompanyCode);
        sb.append(", tenantGroupPcode=").append(tenantGroupPcode);
        sb.append(", tenantType=").append(tenantType);
        sb.append(", tenantGroupVersion=").append(tenantGroupVersion);
        sb.append(", tenantGroupOrderNo=").append(tenantGroupOrderNo);
        sb.append(", tenantGroupUserId=").append(tenantGroupUserId);
        sb.append(", tenantGroupUserName=").append(tenantGroupUserName);
        sb.append(", tenantGroupCtime=").append(tenantGroupCtime);
        sb.append(", tenantGroupMtime=").append(tenantGroupMtime);
        sb.append(", isDelete=").append(isDelete);
        sb.append(", tenantGroupLevel=").append(tenantGroupLevel);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}