package com.pms.ocp.model.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import java.sql.Timestamp;
@Data
@Accessors(chain = true)
@ApiModel("服务事记表")
public class PmsApiAudit {

    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    @Excel(name = "编号",orderNum = "1")
    private String objId;

    @ApiModelProperty("服务编码")
    private String apiCode;

    @ApiModelProperty("操作状态0:新增,1:迭代；2，下线")
    @Excel(name = "类型",orderNum = "3")
    private long operStatus;

    @ApiModelProperty("操作对象0:服务，1:入参，2:出参")
    private long operTarget;

    @ApiModelProperty("类型0:人工操作,1:流程管控,3:总部下发")
    private long auditType;

    @ApiModelProperty("备注简述")
    private String auditMessage;

    @ApiModelProperty("事记内容")
    @Excel(name = "变更内容",orderNum = "4")
    private String auditJson;

    @ApiModelProperty("提交人id")
    private String auditUserId;

    @ApiModelProperty("提交人姓名")
    @Excel(name = "变更人",orderNum = "5")
    private String auditUserName;

    @ApiModelProperty("创建时间")
    @Excel(name = "创建时间",orderNum = "6")
    private Timestamp auditCtime;

    @ApiModelProperty("修改时间")
    private Timestamp auditMtime;

    @ApiModelProperty("是否删除0-否1-是")
    private long isDelete;
    @ApiModelProperty("当前版本")
    private long applyVersion;

    @ApiModelProperty("上一版本")
    @Excel(name = "上一版本",orderNum = "7")
    private long preApiVersion;




    @ApiModelProperty("服务接口中文名称")
    @Excel(name = "服务名称",orderNum = "2")
    private String apiName;

    @ApiModelProperty("服务分类代码")
    private String apiGroupCode;

    @ApiModelProperty("推广类型0:统建；1:自建")
    private long apiPromotion;

    @ApiModelProperty("服务请求体")
    @Excel(name = "请求参数",orderNum = "8")
    private String apiReq;

    @ApiModelProperty("服务返回体")
    @Excel(name = "返回参数",orderNum = "9")
    private String apiResp;

    @ApiModelProperty("服务地址")
    private String apiUrl;

    @ApiModelProperty("服务创建时间")
    private Timestamp apiCtime;

    @ApiModelProperty("服务修改时间")
    private Timestamp apiMtime;

    @ApiModelProperty("创建者用户ID")
    private String apiUserId;

    @ApiModelProperty("建设单位")
    private String apiUnit;

    @ApiModelProperty("服务所属公司")
    private String ownerCompanyCode;



    @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
    private long apiZone;

    @ApiModelProperty("'所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
    private long apiLayer;

    @ApiModelProperty("服务版本（最新版本）")
    @Excel(name = "当前版本",orderNum = "6")
    private String apiVersion;

    @ApiModelProperty("服务所属中心编码所属中心")
    private long apiCenterCode;

    @ApiModelProperty("创建者姓名")
    private long apiUserName;

    @ApiModelProperty("参数版本")
    private String apiParamVersion;

    @ApiModelProperty("参数分类out出参  in入参 ")
    private String apiParamClassification;

    @ApiModelProperty("参数排序")
    private String apiParamOrderNo;

    @ApiModelProperty("参数名称")
    private String apiParamName;

    @ApiModelProperty("参数值")
    private String apiParamValue;

    @ApiModelProperty("是否必须0:不必要 1必要")
    private String isRequire;

    @ApiModelProperty("参数类型")
    private String apiParamType;

}
