package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.sql.Timestamp;
import java.time.LocalDateTime;

@Data
@Accessors(chain = true)
@TableName("ocp_api_model_rel")
@ApiModel("服务模型关系")
public class PmsApiModelRel {

    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    private String objId;

    @ApiModelProperty("模型编码")
    private String modelCode;

    @ApiModelProperty("模型部署公司")
    private String modelDepCompanyCode;

    @ApiModelProperty("服务编码")
    private String apiCode;

    @ApiModelProperty("服务部署公司")
    private String apiDepCompanyCode;

    @ApiModelProperty("关系添加时间")
    private Timestamp relationCtime;

    @ApiModelProperty("是否已删除 0-否1-是")
    private long isDelete;





    @ApiModelProperty("服务接口中文名称")
    private String apiName;

    @ApiModelProperty("服务分类代码")
    private String apiGroupCode;

    @ApiModelProperty("推广类型0:统建；1:自建")
    private long apiPromotion;

    @ApiModelProperty("服务请求体")
    private String apiReq;

    @ApiModelProperty("服务返回体")
    private String apiResp;

    @ApiModelProperty("服务地址")
    private String apiUrl;

    @ApiModelProperty("服务创建时间")
    private Timestamp apiCtime;

    @ApiModelProperty("服务修改时间")
    private Timestamp apiMtime;

    @ApiModelProperty("创建者用户ID")
    private String apiUserId;

    @ApiModelProperty("建设单位")
    private String apiUnit;

    @ApiModelProperty("服务所属公司")
    private String ownerCompanyCode;

    @ApiModelProperty("服务所属公司")
    private String ownerCompanyName;

    @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
    private long apiZone;

    @ApiModelProperty("'所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
    private long apiLayer;

    @ApiModelProperty("服务版本（最新版本）")
    private String apiVersion;

    @ApiModelProperty("服务所属中心编码所属中心")
    private long apiCenterCode;

    @ApiModelProperty("服务简述")
    private String apiDescription;

    @ApiModelProperty("创建者姓名")
    private long apiUserName;


    @ApiModelProperty("模型名称")
    private String modelName;


    @ApiModelProperty("设备类型")
    private String equipType;


    @ApiModelProperty("所属专业ts:输电,t:变电, dc:直流，ds配电，tc:技术，pl计划 im综合")
    private String professionalKind;

    @ApiModelProperty("模型分类编码")
    private String modelGroupCode;


    @ApiModelProperty("模型表名称")
    private String modelTable;


    @ApiModelProperty("是否启用 0:未启用,1：启用")
    @TableField(value = "is_use")
    private Integer boolUse;


    @ApiModelProperty("模型推广类型 0:统推,1：自建")
    private Integer modelPromotion;


    @ApiModelProperty("排列顺序")
    private Integer modelOrderNo;


    @ApiModelProperty("提交人id")
    private String modelUserId;


    @ApiModelProperty("提交人姓名")
    private String modelUserName;


    @ApiModelProperty("模型创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelCtime;


    @ApiModelProperty("模型修改时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modelMtime;



    @ApiModelProperty("是否已删除0:未删除 1:已删除")
    @TableField(value = "is_delete")
    private Integer boolDelete;


    @ApiModelProperty("所属区域1:生成控制大区 2:信息关联大区3:互联网大区")
    private Integer modelZone;


    @ApiModelProperty("所属层级1:应用层 2:平台层3:网络层 4:感知层")
    private Integer modelLayer;


    @ApiModelProperty("模型版本模型版本（最新版本）")
    private String modelVersion;




}
