package com.pms.ocp.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 模型审核vo
 * @author huxiuwu
 * @version 1.0
 * @date 2022/4/6 11:02
 */
@Data
public class ModelCheckVo {

    /**
     * 模型名称
     */
    @ApiModelProperty(value = "模型名称")
    private String modelName;

    /**
     * 模型编码
     */
    @ApiModelProperty(value = "模型编码")
    private String modelCode;
    /**
     * 所属专业
     */
    @ApiModelProperty(value = "所属专业")
    private String belongMajor;

    /**
     * 表名称
     */
    @ApiModelProperty(value = "表名称")
    private String tableName;

    /**
     * 流程类型
     */
    @ApiModelProperty(value = "流程类型")
    private String flowState;

    /**
     * 申请单位名称
     */
    @ApiModelProperty(value = "申请单位名称")
    private String proposerCompanyName;

    /**
     * 申请单位编码
     */
    @ApiModelProperty(value = "申请单位编码")
    private String proposerCompanyCode;
    /**
     * 需求审核状态
     */
    @ApiModelProperty(value = "需求审核状态")
    private Integer demandAuditState;

    /**
     * 审核意见
     */
    @ApiModelProperty(value = "审核意见")
    private String auditOpinion;

    /**
     * 审核人姓名
     */
    @ApiModelProperty(value = "审核人姓名")
    private String auditName;

    /**
     * 审核时间
     */
    @ApiModelProperty(value = "审核时间")
    private Date auditTime;

    /**
     * 需求编码
     */
    @ApiModelProperty(value = "审核时间")
    private String requirementCode;
}
