package com.pms.ocp.model.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/3/29 17:27
 * @Description:模型属性需求展示对象
 */

@ApiModel("模型属性需求展示对象")
@Data
public class ModelPropertyVersionRequirementVO {

    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 模型编码
     */
    @ApiModelProperty(value = "模型编码")
    private String modelCode;

    /**
     * 属性名称
     */
    @ApiModelProperty(value = "属性名称")
    private String columnName;

    /**
     * 模型版本号
     */
    @ApiModelProperty(value = "模型版本号")
    private String modelVersion;

    /**
     * 属性编码
     */
    @ApiModelProperty(value = "属性编码")
    private String propCode;

    /**
     * 属性描述
     */
    @ApiModelProperty(value = "属性描述")
    private String columnComments;

    /**
     * 数据类型
     */
    @ApiModelProperty(value = "数据类型")
    private String dataType;

    /**
     * 数据长度
     */
    @ApiModelProperty(value = "数据长度")
    private Integer dataLength;

    /**
     * 数据精度
     */
    @ApiModelProperty(value = "数据精度")
    private Integer dataScale;

    /**
     * 是否主键 0:否,1:是
     */
    @ApiModelProperty(value = "是否主键 0:否,1:是")
    @TableField("is_pk")
    private Integer boolPk;

    /**
     * 是否必填 0:否,1:是
     */
    @ApiModelProperty(value = "是否必填 0:否,1:是")
    @TableField("is_required")
    private Integer boolRequired;

    /**
     * 显示顺序
     */
    @ApiModelProperty(value = "显示顺序")
    private Integer propOrderNo;

    /**
     * 提交人id
     */
    @ApiModelProperty(value = "提交人id")
    private String propUserId;

    /**
     * 提交人姓名
     */
    @ApiModelProperty(value = "提交人姓名")
    private String propUserName;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime propCtime;

    /**
     * 修改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "修改时间")
    private LocalDateTime propMtime;

    /**
     * 属性推广类型 0:统推, 1：自建
     */
    @ApiModelProperty(value = "属性推广类型 0:统推, 1：自建")
    private Integer propPromotion;

    /**
     * 需求编码
     */
    @ApiModelProperty(value = "需求编码")
    private String requirementCode;

    /**
     * 需求类型 0:新增，1:迭代，2下线
     */
    @ApiModelProperty(value = "需求类型 0:新增，1:迭代，2下线")
    private Integer propRequirementType;

    /**
     * 属性需求描述
     */
    @ApiModelProperty(value = "需求简述")
    private String propRequirementDesc;

    /**
     * 需求提报公司
     */
    @ApiModelProperty(value = "需求提报公司")
    private String companyCode;

    /**
     * 提交人id
     */
    @ApiModelProperty(value = "提交人id")
    private String userId;

    /**
     * 提交人姓名
     */
    @ApiModelProperty(value = "提交人姓名")
    private String userName;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime ctime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    private LocalDateTime mtime;

    /**
     * 需求审核状态0:未通过1:通过
     */
    @ApiModelProperty(value = "需求审核状态0:未通过1:通过")
    private Integer requirementStatus;

}


//    字段名称	字段描述	字段类型	允许为NULL	备注
//        demand_id	主键	varchar(42)	否
//        model_id	模型编号	varchar(42)	否
//        prop_id	属性编号	varchar(42)	是
//        demand_version	版本	varchar(10)	是
//        company_id	省公司ID	varchar(42)	是
//        company_name	省公司名称	varchar(50)	是
//        apply_user_id	提交人id	varchar(42)	否
//        apply_user_name	提交人姓名	varchar(64)	否
//        apply_ctime	创建时间	timestamp(6)	否
//        flow_type	流程类型	int4	否	0:新增,1:迭代
//        flow_message	需求描述	varchar(1000)	是
//        flow_statu	需求审核状态	int4	是	0:不同意, 1：同意
//        flow_comment	审核意见	varchar(100)	是
//        flow_user_id	审核人id	"varchar(42)	"	是
//        flow_user_name	审核人姓名	varchar(64)	是
//        flow_mtime	审核时间	timestamp(6)	是


//  "applyUserId": "",
//          "applyUserName": "",
//          "companyId": "",
//          "companyName": "",
//          "demandVersion": "",
//          "flowComment": "",
//          "flowMessage": "",
//          "flowStatu": 0,
//          "flowType": 0,
//          "flowUserId": "",
//          "flowUserName": "",
//          "model_code": "",
//          "model_name": "",
//          "model_table": ""