package com.pms.ocp.service;

import com.pms.ocp.model.entity.ModelBaseVersion;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/4/1 09:47
 * @Description:模型基础信息版本业务层接口
 */
public interface ModelBaseVersionService {

    /**
     * 创建模型基础版本信息
     *
     * @param modelBaseVersion
     * @return
     */
    Integer createModelBaseVersion(ModelBaseVersion modelBaseVersion);

    /**
     * 删除模型基础版本信息
     *
     * @param requirementCode
     * @param modelCode
     * @return
     */
    Integer deleteModelBaseVersion(String requirementCode, String modelCode);

    /**
     * 更新模型基础版本信息
     *
     * @param modelBaseVersion
     * @return
     */
    Integer updateModelBaseVersion(ModelBaseVersion modelBaseVersion);

    /**
     * 获取模型基础版本信息列表
     *
     * @param modelCodeList
     * @return
     */
    List<ModelBaseVersion> getModelBaseVersionList(String modelCode, List<String> modelCodeList, Integer currentPage, Integer pageSize);

    /**
     * 获取模型基础版本信息
     *
     * @param modelTable
     * @param modelCode
     * @param modelName
     * @return
     */
    ModelBaseVersion getModelBaseVersion(String modelTable, String modelCode, String modelName);

}
