package com.pms.ocp.service;

import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.entity.ModelPropertyVersion;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/4/1 09:47
 * @Description:模型属性版本业务层接口
 */
public interface ModelPropertyVersionService {

    /**
     * 创建模型属性版本信息
     *
     * @param modelPropertyVersion
     * @return
     */
    Integer createModelPropertyVersion(ModelPropertyVersion modelPropertyVersion);

    /**
     * 删除模型属性版本信息
     *
     * @param propCode
     * @param modelCode
     * @param requirementCode
     * @return
     */
    Integer deleteModelPropertyVersion(String requirementCode, String modelCode, String propCode);

    /**
     * 更新模型属性版本信息
     *
     * @param modelPropertyVersion
     * @return
     */
    Integer updateModelPropertyVersion(ModelPropertyVersion modelPropertyVersion);

    /**
     * 获取模型属性版本信息列表
     *
     * @param
     * @return
     */
    List<ModelPropertyVersion> getModelPropertyVersionList(String requirementCode, String modelCode);

}
