package com.pms.ocp.service;

import com.pms.ocp.model.entity.ModelRequirement;
import com.pms.ocp.model.entity.ModelRequirementApproval;
import com.pms.ocp.model.vo.ModelVersionRequirementVO;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/3/29 17:43
 * @Description:模型需求审批业务层接口
 */
public interface ModelRequirementApprovalService {

    /**
     * 创建模型需求审批
     *
     * @param modelRequirementApproval
     * @return
     */
    Integer createModelRequirementApproval(ModelRequirementApproval modelRequirementApproval);

    /**
     * 删除模型需求审批
     *
     * @param objId
     * @param requirementCode
     * @return
     */
    Integer deleteModelRequirementApproval(String objId, String requirementCode);

    /**
     * 更新模型需求审批
     *
     * @param modelRequirementApproval
     * @return
     */
    Integer updateModelRequirementApproval(ModelRequirementApproval modelRequirementApproval);

    /**
     * 获取模型需求审批列表
     *
     * @param
     * @return
     */
    List<ModelVersionRequirementVO> getModelRequirementApprovalList(String modelName, String modelCode, List<String> modelGroupCodes);

    /**
     * 获取模型需求审批
     *
     * @param objId
     * @param modelCode
     * @return
     */
    ModelRequirement getModelRequirementApproval(String objId, String modelCode);

}
