package com.pms.ocp.service;

import com.pms.ocp.model.dto.ModelVersionRequirementDTO;
import com.pms.ocp.model.entity.ModelRequirement;
import com.pms.ocp.model.vo.ModelPropertyVersionRequirementVO;
import com.pms.ocp.model.vo.ModelVersionRequirementVO;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/3/29 17:43
 * @Description:模型需求业务层接口
 */
public interface ModelRequirementService {

    /**
     * 创建模型需求
     *
     * @param modelRequirement
     * @return
     */
    Integer createModelRequirement(ModelRequirement modelRequirement);

    /**
     * 删除模型需求
     *
     * @param objId
     * @param requirementCode
     * @return
     */
    Integer deleteModelRequirement(String objId, String requirementCode);

    /**
     * 更新模型需求
     *
     * @param modelRequirement
     * @return
     */
    Integer updateModelRequirement(ModelRequirement modelRequirement);

    /**
     * 获取模型需求
     *
     * @param
     * @return
     */
    List<ModelVersionRequirementVO> getModelRequirementList(String modelName, String modelCode, List<String> modelGroupCodes);

    /**
     * 获取模型属性需求
     *
     * @param
     * @return
     */
    List<ModelPropertyVersionRequirementVO> getModelPropertyRequirementList(String requirementCode, String modelCode, String columnName);

    /**
     * 获取模型需求列表
     *
     * @param objId
     * @param modelCode
     * @return
     */
    ModelRequirement getModelRequirement(String objId, String modelCode);

}
